/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.participant;

import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.IContentContext;
import org.simantics.g2d.canvas.IMouseCaptureContext;
import org.simantics.g2d.canvas.IMouseCursorContext;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.participant.TransformUtil;

public class SubCanvas
extends AbstractCanvasParticipant {
    @DependencyReflection.Dependency
    TransformUtil util;
    private boolean enabled = true;
    private ICanvasContext superCtx = null;
    private ICanvasContext sub;
    int eventPriority;
    int paintPriority;
    int hintPriority;
    IMouseCursorContext origSubCursorCtx;
    IMouseCaptureContext origSubCaptureCtx;
    IContentContext.IContentListener paintableCtxListener = new IContentContext.IContentListener(){

        @Override
        public void onDirty(IContentContext sender) {
            if (SubCanvas.this.superCtx == null) {
                return;
            }
            SubCanvas.this.superCtx.getContentContext().setDirty();
        }
    };

    public SubCanvas(ICanvasContext subCanvas, int eventPriority, int paintPriority, int hintPriority) {
        assert (subCanvas != null);
        this.sub = subCanvas;
        this.eventPriority = eventPriority;
        this.paintPriority = paintPriority;
        this.hintPriority = hintPriority;
    }

    @Override
    public void addedToContext(ICanvasContext ctx) {
        super.addedToContext(ctx);
        this.superCtx = ctx;
        if (this.enabled) {
            this.enable();
        }
    }

    @Override
    public void removedFromContext(ICanvasContext ctx) {
        assert (this.superCtx == ctx);
        if (this.enabled) {
            this.disable();
        }
        this.superCtx = null;
        super.removedFromContext(ctx);
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        if (enabled) {
            this.enable();
        } else {
            this.disable();
        }
    }

    void enable() {
        this.superCtx.getEventHandlerStack().add((Object)this.sub.getEventHandlerStack(), this.eventPriority);
        this.sub.getContentContext().addPaintableContextListener(this.paintableCtxListener);
        this.origSubCursorCtx = this.sub.getMouseCursorContext();
        this.sub.setMouseCursorContext(this.getContext().getMouseCursorContext());
        this.origSubCaptureCtx = this.sub.getMouseCaptureContext();
        this.sub.setMouseCaptureContext(this.getContext().getMouseCaptureContext());
        assert (this.sub.getDefaultHintContext().getHint(Hints.KEY_SUPER_CANVAS) == null);
        this.enabled = true;
    }

    void disable() {
        this.sub.getDefaultHintContext().removeHint(Hints.KEY_SUPER_CANVAS);
        this.sub.setMouseCaptureContext(this.origSubCaptureCtx);
        this.sub.setMouseCursorContext(this.origSubCursorCtx);
        this.sub.getContentContext().removePaintableContextListener(this.paintableCtxListener);
        this.superCtx.getEventHandlerStack().remove((Object)this.sub.getEventHandlerStack());
        this.enabled = false;
    }
}

