/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.participant;

import java.util.HashSet;
import java.util.Set;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.KeyEvent;

public class KeyUtil
extends AbstractCanvasParticipant {
    private Set<Integer> pressedByKeyCode = new HashSet<Integer>();
    private Set<Character> pressedByChar = new HashSet<Character>();

    @EventHandlerReflection.EventHandler(priority=0x7FFFFFFF)
    public boolean handleClick(KeyEvent e) {
        if (e instanceof KeyEvent.KeyPressedEvent) {
            this.pressedByKeyCode.add(e.keyCode);
            this.pressedByChar.add(Character.valueOf(e.character));
        } else if (e instanceof KeyEvent.KeyReleasedEvent) {
            this.pressedByKeyCode.remove(e.keyCode);
            this.pressedByChar.remove(Character.valueOf(e.character));
        }
        return false;
    }

    public boolean isCharPressed(char c) {
        return this.pressedByChar.contains(Character.valueOf(c));
    }

    public boolean isKeyPressed(int keyCode) {
        return this.pressedByKeyCode.contains(keyCode);
    }
}

