/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.image.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.image.VolatileImage;
import org.simantics.g2d.image.Image;
import org.simantics.g2d.image.impl.ImageProxy;

public class VRamBufferedImage
extends ImageProxy {
    Shape outline;
    final GraphicsConfiguration gc;
    VolatileImage image;
    int wid;
    int hei;

    public VRamBufferedImage(Image original, GraphicsConfiguration gc) {
        super(original);
        assert (gc != null);
        this.gc = gc;
        Rectangle2D bounds = original.getBounds();
        this.wid = (int)Math.ceil(bounds.getWidth());
        this.hei = (int)Math.ceil(bounds.getHeight());
    }

    synchronized VolatileImage restore() {
        int validateResult;
        if (this.image == null) {
            this.image = this.gc.createCompatibleVolatileImage(this.wid, this.hei, 3);
        }
        if ((validateResult = this.image.validate(this.gc)) == 2) {
            return null;
        }
        if (validateResult == 0) {
            return this.image;
        }
        if (validateResult == 1) {
            Rectangle2D bounds = this.source.getBounds();
            this.outline = this.source.getOutline();
            Graphics2D target = this.image.createGraphics();
            target.setBackground(new Color(255, 255, 255, 0));
            target.clearRect(0, 0, this.image.getWidth(), this.image.getHeight());
            target.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            target.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            target.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            target.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            target.translate(-bounds.getMinX(), -bounds.getMinY());
            this.source.init(null);
            target.dispose();
            return this.image;
        }
        return null;
    }

    public int hashCode() {
        return this.gc.hashCode() ^ this.source.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof VRamBufferedImage)) {
            return false;
        }
        VRamBufferedImage o = (VRamBufferedImage)obj;
        return o.gc == this.gc && o.source.equals(this.source);
    }

    public Image getSource() {
        return this.source;
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        return this.gc;
    }
}

