/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.image.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.simantics.g2d.image.Image;
import org.simantics.g2d.image.impl.ImageProxy;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.utils.QualityHints;

public class MipMapBufferedImage
extends ImageProxy
implements Image {
    public static final double MARGIN_PERCENT = 3.0;
    public static final double MAX_DIMENSION = 800.0;
    public static final double MIN_DIMENSION = 4.0;
    Shape outline;
    double[] resolutions;
    Map<Double, Raster> rasters = new HashMap<Double, Raster>();
    double minResolution;
    double maxResolution;
    EnumSet<Image.Feature> caps;

    public MipMapBufferedImage(Image original) {
        super(original);
        this.source = original;
        double maxResolution = this.maxResolution();
        double minResolution = this.minResolution();
        double resolution = maxResolution;
        ArrayList<Double> resolutions = new ArrayList<Double>();
        while (resolution > minResolution) {
            Raster r = new Raster(resolution);
            this.rasters.put(resolution, r);
            resolutions.add(resolution);
            resolution /= 2.0;
        }
        this.resolutions = new double[resolutions.size()];
        int i = 0;
        while (i < resolutions.size()) {
            this.resolutions[i] = (Double)resolutions.get(resolutions.size() - 1 - i);
            ++i;
        }
        this.minResolution = this.resolutions[0];
        this.maxResolution = this.resolutions[this.resolutions.length - 1];
        boolean vola = this.source.getFeatures().contains((Object)Image.Feature.Volatile);
        if (vola) {
            this.source.addImageListener(new Image.ImageListener(){

                @Override
                public void onContentChangedNotification(Image image) {
                    MipMapBufferedImage.this.releaseRaster();
                }
            });
            this.caps = EnumSet.of(Image.Feature.Volatile);
        } else {
            this.caps = EnumSet.noneOf(Image.Feature.class);
        }
    }

    private double maxResolution() {
        Rectangle2D bounds = this.source.getBounds();
        double wid = bounds.getWidth();
        double hei = bounds.getHeight();
        return 800.0 / Math.sqrt(wid * hei);
    }

    private double minResolution() {
        Rectangle2D bounds = this.source.getBounds();
        double wid = bounds.getWidth();
        double hei = bounds.getHeight();
        return 4.0 / Math.sqrt(wid * hei);
    }

    private double requiredResolution(AffineTransform at) {
        double m00 = at.getScaleX();
        double m11 = at.getScaleY();
        double m10 = at.getShearY();
        double m01 = at.getShearX();
        double sx = Math.sqrt(m00 * m00 + m10 * m10);
        double sy = Math.sqrt(m01 * m01 + m11 * m11);
        return Math.sqrt(sx * sx + sy * sy);
    }

    private double findClosestResolution(double resolution) {
        int index = Arrays.binarySearch(this.resolutions, resolution);
        if (index >= 0) {
            return this.resolutions[index];
        }
        if ((index = -(index + 1)) >= this.resolutions.length) {
            index = this.resolutions.length - 1;
        }
        if (index < 0) {
            index = 0;
        }
        return this.resolutions[index];
    }

    @Override
    public Node init(G2DParentNode parent) {
        return null;
    }

    public Image getOriginalPaintableSymbol() {
        return this.source;
    }

    synchronized void releaseRaster() {
        for (Raster r : this.rasters.values()) {
            r.image = null;
        }
    }

    @Override
    protected void notifyChanged() {
        this.releaseRaster();
        super.notifyChanged();
    }

    @Override
    public EnumSet<Image.Feature> getFeatures() {
        return this.caps;
    }

    public Image getSource() {
        return this.source;
    }

    class Raster
    implements Comparable<Raster> {
        BufferedImage image;
        double resolution;
        int wid;
        int hei;

        Raster(double resolution) {
            Rectangle2D bounds = MipMapBufferedImage.this.source.getBounds();
            this.resolution = resolution;
            double wid = bounds.getWidth();
            double hei = bounds.getHeight();
            this.wid = (int)(wid * resolution);
            this.hei = (int)(hei * resolution);
        }

        synchronized BufferedImage getOrCreate() {
            if (this.image != null) {
                return this.image;
            }
            Rectangle2D bounds = MipMapBufferedImage.this.source.getBounds();
            this.image = new BufferedImage(this.wid + 0 + 1, this.hei + 0 + 1, 2);
            Graphics2D target = this.image.createGraphics();
            target.setBackground(new Color(255, 255, 255, 0));
            target.clearRect(0, 0, this.image.getWidth(), this.image.getHeight());
            QualityHints.HIGH_QUALITY_HINTS.setQuality(target);
            target.scale(this.resolution, this.resolution);
            target.translate(-bounds.getMinX(), -bounds.getMinY());
            MipMapBufferedImage.this.source.init(null);
            target.dispose();
            return this.image;
        }

        @Override
        public int compareTo(Raster other) {
            if (other.resolution < this.resolution) {
                return -1;
            }
            if (other.resolution > this.resolution) {
                return 1;
            }
            return 0;
        }
    }
}

