/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.gallery;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.tooltip.AWTTooltipProvider;
import org.simantics.utils.datastructures.hints.IHintContext;

public class GalleryTooltipProvider
extends AWTTooltipProvider {
    public static IHintContext.Key TOOLTIP_TEXT = new IHintContext.KeyOf(String.class, "TOOLTIP_TEXT");
    public static IHintContext.Key TOOLTIP_IMAGE = new IHintContext.KeyOf(Image.class, "TOOLTIP_IMAGE");

    @Override
    public void constructPopup(Frame frame, IElement element) {
        String text = (String)element.getHint(TOOLTIP_TEXT);
        final Image image = (Image)element.getHint(TOOLTIP_IMAGE);
        if (text == null && image == null) {
            return;
        }
        frame.setLayout(new BoxLayout(frame, 0));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        Color c = new Color(255, 255, 220);
        panel.setBackground(c);
        panel.setBorder(BorderFactory.createLineBorder(Color.black));
        if (image != null) {
            Canvas canvas = new Canvas(){
                private static final long serialVersionUID = -7357041194563374338L;

                @Override
                public void paint(Graphics g) {
                    super.paint(g);
                    g.drawImage(image, 0, 0, null);
                }

                @Override
                public Dimension getSize() {
                    return new Dimension(image.getWidth(null), image.getHeight(null));
                }

                @Override
                public Dimension getSize(Dimension rv) {
                    if (rv == null) {
                        rv = new Dimension();
                    }
                    rv.width = image.getWidth(null);
                    rv.height = image.getHeight(null);
                    return rv;
                }
            };
            panel.add(canvas);
        }
        if (text != null) {
            JLabel label = new JLabel(text);
            panel.add(label);
        }
        frame.add(panel);
    }
}

