/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.element.handler.impl;

import java.awt.BasicStroke;
import java.awt.Stroke;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.EdgeVisuals;
import org.simantics.g2d.element.handler.LifeCycle;

public class ConfigurableEdgeVisuals
implements EdgeVisuals,
LifeCycle {
    private static final long serialVersionUID = -8662807810086649742L;
    public static final Stroke DEFAULT_STROKE = new BasicStroke(0.15f, 0, 1, 10.0f, null, 0.0f);
    public static final ConfigurableEdgeVisuals DEFAULT = new ConfigurableEdgeVisuals(EdgeVisuals.ArrowType.None, EdgeVisuals.ArrowType.Fill, DEFAULT_STROKE, 1.0, 1.0);
    EdgeVisuals.ArrowType beginArrow;
    EdgeVisuals.ArrowType endArrow;
    public Stroke stroke;
    public EdgeVisuals.StrokeType strokeType;
    double beginArrowSize;
    double endArrowSize;

    public ConfigurableEdgeVisuals() {
        this.beginArrow = EdgeVisuals.ArrowType.Stroke;
        this.endArrow = EdgeVisuals.ArrowType.Stroke;
        this.stroke = DEFAULT_STROKE;
        this.strokeType = EdgeVisuals.StrokeType.Relative;
        this.beginArrowSize = 1.0;
        this.endArrowSize = 1.0;
    }

    public ConfigurableEdgeVisuals(EdgeVisuals.ArrowType initialBeginArrow, EdgeVisuals.ArrowType initialEndArrow, Stroke initialStroke, double beginArrowSize, double endArrowSize) {
        this.beginArrow = initialBeginArrow;
        this.endArrow = initialEndArrow;
        this.stroke = initialStroke;
        this.strokeType = EdgeVisuals.StrokeType.Relative;
        this.beginArrowSize = beginArrowSize;
        this.endArrowSize = endArrowSize;
    }

    public ConfigurableEdgeVisuals(EdgeVisuals.ArrowType initialBeginArrow, EdgeVisuals.ArrowType initialEndArrow, Stroke initialStroke, EdgeVisuals.StrokeType initialStrokeType, double beginArrowSize, double endArrowSize) {
        this.beginArrow = initialBeginArrow;
        this.endArrow = initialEndArrow;
        this.stroke = initialStroke;
        this.strokeType = initialStrokeType;
        this.beginArrowSize = beginArrowSize;
        this.endArrowSize = endArrowSize;
    }

    @Override
    public EdgeVisuals.ArrowType getArrowType(IElement e, EdgeVisuals.EdgeEnd end) {
        if (end == EdgeVisuals.EdgeEnd.Begin) {
            return (EdgeVisuals.ArrowType)((Object)e.getHint(ElementHints.KEY_BEGIN_ARROW));
        }
        if (end == EdgeVisuals.EdgeEnd.End) {
            return (EdgeVisuals.ArrowType)((Object)e.getHint(ElementHints.KEY_END_ARROW));
        }
        return null;
    }

    @Override
    public EdgeVisuals.StrokeType getStrokeType(IElement e) {
        return (EdgeVisuals.StrokeType)((Object)e.getHint(ElementHints.KEY_EDGE_STROKE_TYPE));
    }

    @Override
    public Stroke getStroke(IElement e) {
        return (Stroke)e.getHint(ElementHints.KEY_EDGE_STROKE);
    }

    @Override
    public void setArrowType(IElement e, EdgeVisuals.EdgeEnd end, EdgeVisuals.ArrowType arrowType) {
        if (end == EdgeVisuals.EdgeEnd.Begin) {
            e.setHint(ElementHints.KEY_BEGIN_ARROW, (Object)arrowType);
        }
        if (end == EdgeVisuals.EdgeEnd.End) {
            e.setHint(ElementHints.KEY_END_ARROW, (Object)arrowType);
        }
    }

    @Override
    public void setStrokeType(IElement e, EdgeVisuals.StrokeType strokeType) {
        e.setHint(ElementHints.KEY_EDGE_STROKE_TYPE, (Object)strokeType);
    }

    @Override
    public void setStroke(IElement e, Stroke s) {
        e.setHint(ElementHints.KEY_EDGE_STROKE, s);
    }

    @Override
    public void onElementActivated(IDiagram d, IElement e) {
    }

    @Override
    public void onElementCreated(IElement e) {
        e.setHint(ElementHints.KEY_BEGIN_ARROW, (Object)this.beginArrow);
        e.setHint(ElementHints.KEY_END_ARROW, (Object)this.endArrow);
        e.setHint(ElementHints.KEY_EDGE_STROKE, this.stroke);
        e.setHint(ElementHints.KEY_EDGE_STROKE_TYPE, (Object)this.strokeType);
        e.setHint(ElementHints.KEY_BEGIN_ARROW_SIZE, this.beginArrowSize);
        e.setHint(ElementHints.KEY_END_ARROW_SIZE, this.endArrowSize);
    }

    @Override
    public void onElementDeactivated(IDiagram d, IElement e) {
    }

    @Override
    public void onElementDestroyed(IElement e) {
    }

    @Override
    public double getArrowSize(IElement e, EdgeVisuals.EdgeEnd end) {
        if (end == EdgeVisuals.EdgeEnd.Begin) {
            return (Double)e.getHint(ElementHints.KEY_BEGIN_ARROW_SIZE);
        }
        if (end == EdgeVisuals.EdgeEnd.End) {
            return (Double)e.getHint(ElementHints.KEY_END_ARROW_SIZE);
        }
        return 0.0;
    }

    @Override
    public void setArrowSize(IElement e, EdgeVisuals.EdgeEnd end, double size) {
        if (end == EdgeVisuals.EdgeEnd.Begin) {
            e.setHint(ElementHints.KEY_BEGIN_ARROW_SIZE, size);
        } else if (end == EdgeVisuals.EdgeEnd.End) {
            e.setHint(ElementHints.KEY_END_ARROW_SIZE, size);
        }
    }
}

