/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.diagram.participant;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.List;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.canvas.impl.SGNodeReflection;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.participant.AbstractDiagramParticipant;
import org.simantics.g2d.diagram.participant.pointertool.PointerInteractor;
import org.simantics.g2d.diagram.participant.pointertool.TerminalUtil;
import org.simantics.g2d.participant.MouseUtil;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.g2d.utils.GeometryUtils;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.nodes.ShapeNode;
import org.simantics.scenegraph.utils.ColorUtil;
import org.simantics.utils.datastructures.hints.HintListenerAdapter;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerminalPainter
extends AbstractDiagramParticipant {
    private static final Logger LOGGER = LoggerFactory.getLogger(TerminalPainter.class);
    public static final int PAINT_PRIORITY = 20;
    public static final IHintContext.Key TERMINAL_HOVER_STRATEGY = new IHintContext.KeyOf(TerminalHoverStrategy.class);
    private static final Stroke STROKE25 = new BasicStroke(2.5f);
    public static final Shape TERMINAL_SHAPE;
    @DependencyReflection.Dependency
    protected TransformUtil util;
    @DependencyReflection.Dependency
    protected MouseUtil mice;
    @DependencyReflection.Dependency
    protected PointerInteractor pointerInteractor;
    protected boolean paintPointTerminals;
    protected boolean paintAreaTerminals;
    protected boolean paintHoverPointTerminals;
    protected boolean paintHoverAreaTerminals;
    protected G2DParentNode node = null;
    IHintListener hoverStrategyListener = new HintListenerAdapter(){

        public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
            TerminalPainter.this.hoverStrategyChanged((TerminalHoverStrategy)newValue);
        }
    };

    static {
        Path2D.Double cross = new Path2D.Double();
        double s = 2.0;
        cross.moveTo(-s, -s);
        cross.lineTo(s, s);
        cross.moveTo(-s, s);
        cross.lineTo(s, -s);
        TERMINAL_SHAPE = cross;
    }

    public TerminalPainter(boolean paintPointTerminals, boolean paintHoverPointTerminals, boolean paintAreaTerminals, boolean paintHoverAreaTerminals) {
        this.paintAreaTerminals = paintAreaTerminals;
        this.paintPointTerminals = paintPointTerminals;
        this.paintHoverAreaTerminals = paintHoverAreaTerminals;
        this.paintHoverPointTerminals = paintHoverPointTerminals;
    }

    @Override
    public void addedToContext(ICanvasContext ctx) {
        super.addedToContext(ctx);
        ctx.getHintStack().addKeyHintListener(this.getContext().getThreadAccess(), TERMINAL_HOVER_STRATEGY, this.hoverStrategyListener);
    }

    @Override
    public void removedFromContext(ICanvasContext ctx) {
        ctx.getHintStack().removeKeyHintListener(this.getContext().getThreadAccess(), TERMINAL_HOVER_STRATEGY, this.hoverStrategyListener);
        super.removedFromContext(ctx);
    }

    public boolean highlightEnabled() {
        TerminalHoverStrategy strategy = (TerminalHoverStrategy)this.getHint(TERMINAL_HOVER_STRATEGY);
        return strategy != null ? strategy.highlightEnabled() : true;
    }

    public boolean highlightTerminal(TerminalUtil.TerminalInfo ti) {
        TerminalHoverStrategy strategy = (TerminalHoverStrategy)this.getHint(TERMINAL_HOVER_STRATEGY);
        return strategy != null ? strategy.highlight(ti) : true;
    }

    @EventHandlerReflection.EventHandler(priority=0)
    public boolean handleMove(MouseEvent.MouseMovedEvent me) {
        if (this.paintHoverAreaTerminals && this.paintAreaTerminals || this.paintHoverPointTerminals && this.paintPointTerminals) {
            this.update(this.highlightEnabled());
        }
        return false;
    }

    @SGNodeReflection.SGInit
    public void initSG(G2DParentNode parent) {
        this.node = (G2DParentNode)parent.addNode("hovering terminals", G2DParentNode.class);
        this.node.setZIndex(20);
    }

    @SGNodeReflection.SGCleanup
    public void cleanupSG() {
        this.node.remove();
        this.node = null;
    }

    public void update(boolean enabled) {
        if (this.isRemoved()) {
            return;
        }
        boolean repaint = false;
        if (this.node == null) {
            return;
        }
        if (this.node.getNodeCount() > 0) {
            this.node.removeNodes();
            repaint = true;
        }
        if (enabled) {
            if (this.paintAreaTerminals || this.paintPointTerminals) {
                List<TerminalUtil.TerminalInfo> pickedTerminals = TerminalUtil.pickTerminals(this.getContext(), this.diagram, null, this.paintPointTerminals, this.paintAreaTerminals);
                this.paintTerminals(this.node, Color.BLUE, this.diagram, null, pickedTerminals, null);
                if (pickedTerminals.size() > 0) {
                    repaint = true;
                }
            }
            if (this.paintHoverAreaTerminals || this.paintHoverPointTerminals) {
                TerminalHoverStrategy strategy = (TerminalHoverStrategy)this.getHint(TERMINAL_HOVER_STRATEGY);
                AffineTransform invTx = this.util.getInverseTransform();
                if (invTx == null) {
                    LOGGER.warn("NO CANVAS TRANSFORM INVERSE AVAILABLE, CANVAS TRANSFORM IS: " + this.util.getTransform());
                    return;
                }
                for (MouseUtil.MouseInfo mi : this.mice.getMiceInfo().values()) {
                    Rectangle2D controlPickRect = this.getPickRectangle(mi.controlPosition.getX(), mi.controlPosition.getY());
                    Shape canvasPickRect = GeometryUtils.transformShape(controlPickRect, invTx);
                    List<TerminalUtil.TerminalInfo> tis = TerminalUtil.pickTerminals(this.getContext(), this.diagram, canvasPickRect, this.paintHoverAreaTerminals, this.paintHoverPointTerminals);
                    this.paintTerminals(this.node, Color.RED, this.diagram, canvasPickRect.getBounds2D(), tis, strategy);
                    if (tis.size() <= 0) continue;
                    repaint = true;
                }
            }
        }
        if (repaint) {
            this.setDirty();
        }
    }

    public void paintTerminals(G2DParentNode parent, Color color, IDiagram diagram, Rectangle2D pickRect, Collection<TerminalUtil.TerminalInfo> tis, TerminalHoverStrategy strategy) {
        if (tis.isEmpty()) {
            return;
        }
        G2DParentNode node = (G2DParentNode)parent.getOrCreateNode("" + tis.hashCode(), G2DParentNode.class);
        double minDist = Double.MAX_VALUE;
        double maxDist = 0.0;
        TerminalUtil.TerminalInfo nearest = null;
        if (pickRect != null) {
            for (TerminalUtil.TerminalInfo ti : tis) {
                double dy;
                double dx = ti.posDia.getTranslateX() - pickRect.getCenterX();
                double dist = Math.sqrt(dx * dx + (dy = ti.posDia.getTranslateY() - pickRect.getCenterY()) * dy);
                if (dist > maxDist) {
                    maxDist = dist;
                }
                if (!(dist < minDist)) continue;
                minDist = dist;
                nearest = ti;
            }
        }
        for (TerminalUtil.TerminalInfo ti : tis) {
            if (strategy != null && !strategy.highlight(ti)) continue;
            Shape shape = ti.shape != null ? ti.shape : this.getTerminalShape();
            ShapeNode sn = (ShapeNode)node.getOrCreateNode("terminal_" + ti.hashCode(), ShapeNode.class);
            sn.setShape(shape);
            sn.setStroke(STROKE25);
            sn.setScaleStroke(true);
            if (pickRect != null) {
                Color blendedColor = color;
                if (ti != nearest) {
                    double dx = ti.posDia.getTranslateX() - pickRect.getCenterX();
                    double dy = ti.posDia.getTranslateY() - pickRect.getCenterY();
                    double dist = Math.sqrt(dx * dx + dy * dy);
                    double normalizedDistance = dist / maxDist;
                    float alpha = (float)(1.0 - normalizedDistance * 0.5);
                    blendedColor = ColorUtil.withAlpha((Color)ColorUtil.blend((Color)color, (Color)Color.WHITE, (double)(normalizedDistance * 0.5)), (float)alpha);
                }
                sn.setColor((Paint)blendedColor);
            } else {
                sn.setColor((Paint)color);
            }
            sn.setTransform(ti.posDia);
            sn.setFill(false);
        }
    }

    public Rectangle2D getTerminalShape() {
        double pickDist = this.pointerInteractor.getTerminalPickDistance();
        return new Rectangle2D.Double(-pickDist - 0.5, -pickDist - 0.5, pickDist * 2.0 + 1.0, pickDist * 2.0 + 1.0);
    }

    public Rectangle2D getPickRectangle(double x, double y) {
        double pickDist = this.pointerInteractor.getTerminalPickDistance();
        Rectangle2D.Double controlPickRect = new Rectangle2D.Double(x - pickDist, y - pickDist, pickDist * 2.0, pickDist * 2.0);
        return controlPickRect;
    }

    protected void hoverStrategyChanged(TerminalHoverStrategy strategy) {
        this.update(strategy != null ? strategy.highlightEnabled() : false);
    }

    public static abstract class ChainedHoverStrategy
    implements TerminalHoverStrategy {
        TerminalHoverStrategy orig;

        public ChainedHoverStrategy(TerminalHoverStrategy orig) {
            this.orig = orig;
        }

        @Override
        public boolean highlightEnabled() {
            return this.orig == null ? false : this.orig.highlightEnabled();
        }

        @Override
        public final boolean highlight(TerminalUtil.TerminalInfo ti) {
            boolean ret = this.canHighlight(ti);
            return ret || this.orig == null ? ret : this.orig.highlight(ti);
        }

        public abstract boolean canHighlight(TerminalUtil.TerminalInfo var1);
    }

    public static interface TerminalHoverStrategy {
        public boolean highlightEnabled();

        public boolean highlight(TerminalUtil.TerminalInfo var1);
    }
}

