/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.diagram.participant;

import java.util.Map;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.CanvasListener;
import org.simantics.g2d.diagram.participant.AbstractDiagramParticipant;
import org.simantics.g2d.element.IElement;
import org.simantics.utils.datastructures.hints.HintContext;
import org.simantics.utils.datastructures.hints.IHintContext;

public class DiagramParticipant
extends AbstractDiagramParticipant {
    IHintContext ctx = new HintContext();
    IDiagram.CompositionListener listener = new IDiagram.CompositionListener(){

        @Override
        public void onElementAdded(IDiagram d, IElement e) {
        }

        @Override
        public void onElementRemoved(IDiagram d, IElement e) {
        }
    };

    @Override
    protected void onDiagramSet(IDiagram newDiagram, IDiagram oldDiagram) {
        if (this.clazz == null) {
            return;
        }
        for (CanvasListener cm : this.clazz.getItemsByClass(CanvasListener.class)) {
            cm.onAddedToCanvas(newDiagram, this.getContext());
        }
        if (newDiagram == null) {
            for (IHintContext.Key key : this.ctx.getHints().keySet()) {
                this.ctx.removeHint(key);
            }
        }
        if (oldDiagram != null) {
            oldDiagram.removeCompositionListener(this.listener);
        }
        if (newDiagram != null) {
            newDiagram.addCompositionListener(this.listener);
        }
    }

    public void setElementHint(IElement e, IHintContext.Key key, Object value) {
        ElementCtxKey elementCtxKey = new ElementCtxKey(e);
        IHintContext elementCtx = (IHintContext)this.ctx.getHint((IHintContext.Key)elementCtxKey);
        if (elementCtx == null) {
            elementCtx = new HintContext();
            this.ctx.setHint((IHintContext.Key)elementCtxKey, (Object)elementCtx);
        }
        elementCtx.setHint(key, value);
    }

    public <E> E getElementHint(IElement e, IHintContext.Key key) {
        ElementCtxKey elementCtxKey = new ElementCtxKey(e);
        IHintContext elementCtx = (IHintContext)this.ctx.getHint((IHintContext.Key)elementCtxKey);
        if (elementCtx == null) {
            return null;
        }
        return (E)elementCtx.getHint(key);
    }

    public Map<IHintContext.Key, Object> getElementHints(IElement e) {
        ElementCtxKey elementCtxKey = new ElementCtxKey(e);
        IHintContext elementCtx = (IHintContext)this.ctx.getHint((IHintContext.Key)elementCtxKey);
        if (elementCtx == null) {
            return null;
        }
        return elementCtx.getHints();
    }

    public <E> E removeElementHint(IElement e, IHintContext.Key key) {
        ElementCtxKey elementCtxKey = new ElementCtxKey(e);
        IHintContext elementCtx = (IHintContext)this.ctx.getHint((IHintContext.Key)elementCtxKey);
        if (elementCtx == null) {
            return null;
        }
        return (E)elementCtx.removeHint(key);
    }

    public void setDiagramHint(IDiagram d, IHintContext.Key key, Object value) {
        this.ctx.setHint(key, value);
    }

    public <E> E removeDiagramHint(IDiagram d, IHintContext.Key key) {
        return (E)this.ctx.removeHint(key);
    }

    private class DiagramKey
    extends IHintContext.Key {
        public final IDiagram d;
        private final int hash;
        public final IHintContext.Key key;

        public DiagramKey(IDiagram d, IHintContext.Key key) {
            assert (key != null);
            this.key = key;
            this.d = d;
            this.hash = key.hashCode() ^ d.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DiagramKey)) {
                return false;
            }
            DiagramKey other = (DiagramKey)((Object)obj);
            if (other.key.equals(this.key)) {
                return false;
            }
            return other.d == this.d;
        }

        public boolean isValueAccepted(Object value) {
            return this.key.isValueAccepted(value);
        }
    }

    private class ElementCtxKey
    extends IHintContext.Key {
        public final IElement e;

        public ElementCtxKey(IElement e) {
            this.e = e;
        }

        public int hashCode() {
            return this.e.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ElementCtxKey)) {
                return false;
            }
            ElementCtxKey other = (ElementCtxKey)((Object)obj);
            return other.e == this.e;
        }

        public boolean isValueAccepted(Object value) {
            return value instanceof IHintContext;
        }
    }

    private class ElementKey
    extends IHintContext.Key {
        public final IElement e;
        private final int hash;
        public final IHintContext.Key key;

        public ElementKey(IElement e, IHintContext.Key key) {
            assert (key != null);
            this.key = key;
            this.e = e;
            this.hash = key.hashCode() ^ e.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ElementKey)) {
                return false;
            }
            ElementKey other = (ElementKey)((Object)obj);
            if (other.e != this.e) {
                return false;
            }
            return other.key.equals(this.key);
        }

        public boolean isValueAccepted(Object value) {
            return this.key.isValueAccepted(value);
        }
    }
}

