/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.diagram.handler.impl;

import java.util.Collection;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.LifeCycle;
import org.simantics.g2d.diagram.handler.TransactionContext;
import org.simantics.g2d.element.IElement;
import org.simantics.utils.datastructures.ListenerList;
import org.simantics.utils.datastructures.hints.IHintContext;

public class LockingTransactionContext
implements TransactionContext,
LifeCycle {
    public static final LockingTransactionContext INSTANCE = new LockingTransactionContext();
    private static final IHintContext.Key TRANSACTION_LISTENERS = new IHintContext.KeyOf(ListenerList.class, "TRANSACTION LISTENERS");
    private static final IHintContext.Key TRANSACTION_LOCK = new IHintContext.KeyOf(ReadWriteLock.class, "TRANSACTION LOCK");

    @Override
    public void onDiagramCreated(IDiagram diagram) {
        diagram.setHint(TRANSACTION_LISTENERS, new ListenerList(TransactionContext.TransactionListener.class));
        diagram.setHint(TRANSACTION_LOCK, new ReentrantReadWriteLock(true));
    }

    @Override
    public void onDiagramLoaded(IDiagram diagram, Collection<IElement> initialElements) {
    }

    @Override
    public void onDiagramDestroyed(IDiagram diagram) {
    }

    @Override
    public void onDiagramDisposed(IDiagram diagram) {
        diagram.removeHint(TRANSACTION_LISTENERS);
        diagram.removeHint(TRANSACTION_LOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTransactionListener(IDiagram d, TransactionContext.TransactionListener l) {
        ListenerList ll;
        IDiagram iDiagram = d;
        synchronized (iDiagram) {
            ll = (ListenerList)d.getHint(TRANSACTION_LISTENERS);
            if (ll == null) {
                ll = new ListenerList(TransactionContext.TransactionListener.class);
                d.setHint(TRANSACTION_LISTENERS, ll);
            }
        }
        ll.add((Object)l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTransactionListener(IDiagram d, TransactionContext.TransactionListener l) {
        IDiagram iDiagram = d;
        synchronized (iDiagram) {
            ListenerList ll = (ListenerList)d.getHint(TRANSACTION_LISTENERS);
            if (ll == null) {
                return;
            }
            ll.remove((Object)l);
        }
    }

    void lock(ReadWriteLock lock, TransactionContext.TransactionType type) {
        switch (type) {
            case READ: {
                lock.readLock().lock();
                return;
            }
            case WRITE: {
                lock.writeLock().lock();
                return;
            }
        }
    }

    void unlock(ReadWriteLock lock, TransactionContext.TransactionType type) {
        switch (type) {
            case READ: {
                lock.readLock().unlock();
                return;
            }
            case WRITE: {
                lock.writeLock().unlock();
                return;
            }
        }
    }

    @Override
    public TransactionContext.Transaction startTransaction(IDiagram d, TransactionContext.TransactionType type) {
        ReadWriteLock lock = (ReadWriteLock)d.getHint(TRANSACTION_LOCK);
        assert (lock != null);
        this.lock(lock, type);
        try {
            TransactionContext.Transaction.Impl t = new TransactionContext.Transaction.Impl(type);
            ListenerList ll = (ListenerList)d.getHint(TRANSACTION_LISTENERS);
            if (ll != null) {
                TransactionContext.TransactionListener[] transactionListenerArray = (TransactionContext.TransactionListener[])ll.getListeners();
                int n = transactionListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TransactionContext.TransactionListener l = transactionListenerArray[n2];
                    l.transactionStarted(d, t);
                    ++n2;
                }
            }
            return t;
        }
        catch (RuntimeException e) {
            this.unlock(lock, type);
            throw e;
        }
    }

    @Override
    public void finishTransaction(IDiagram d, TransactionContext.Transaction t) {
        ReadWriteLock lock = (ReadWriteLock)d.getHint(TRANSACTION_LOCK);
        assert (lock != null);
        try {
            ListenerList ll = (ListenerList)d.getHint(TRANSACTION_LISTENERS);
            if (ll != null) {
                TransactionContext.TransactionListener[] transactionListenerArray = (TransactionContext.TransactionListener[])ll.getListeners();
                int n = transactionListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TransactionContext.TransactionListener l = transactionListenerArray[n2];
                    l.transactionFinished(d, t);
                    ++n2;
                }
            }
        }
        finally {
            this.unlock(lock, t.getType());
        }
    }
}

