/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.utils;



/**
 * @author Tuukka Lehtonen
 */
public enum Alignment {

    /**
     * Indicates the elements should be aligned to the origin. For the
     * horizontal axis with a left to right orientation this means aligned to
     * the left edge. For the vertical axis leading means aligned to the top
     * edge.
     */
    LEADING,

    /**
     * Indicates the elements should be aligned to the end of the region. For
     * the horizontal axis with a left to right orientation this means aligned
     * to the right edge. For the vertical axis trailing means aligned to the
     * bottom edge.
     */
    TRAILING,

    /**
     * Indicates the elements should be centered in the region.
     */
    CENTER,

    /**
     * Indicates the elements should be aligned along their baseline.
     * 
     * @since 1.6
     */
    BASELINE

}
