/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.svg;

import java.util.HashSet;
import java.util.Set;

/**
 * @author Tuukka Lehtonen
 */
public final class SVGUnits {

    /**
     * inches, 1in = 2.54cm
     */
    public static final String UNIT_IN = "in";
    
    /**
     * centimeters, 1cm = 10mm
     */
    public static final String UNIT_CM = "cm";
    
    /**
     * millimeters
     */
    public static final String UNIT_MM = "mm";
    
    /**
     * points, 1pt = 1/72in
     */
    public static final String UNIT_PT = "pt";
    
    /**
     * picas, 1pc = 12pt
     */
    public static final String UNIT_PC = "pc";
    
    /**
     * px (pixels, relative to the canvas resolution)
     */
    public static final String UNIT_PX = "px";
    
    /**
     * User units, equal to px, i.e. pixel units.
     */
    public static final String UNIT_USER = UNIT_PX;
    

    private static final Set<String> validUnitSet;
    
    private static final String[] validUnits = {
        UNIT_IN,
        UNIT_CM,
        UNIT_MM,
        UNIT_PT,
        UNIT_PC,
        UNIT_PX,        
    };
    
    static {
        validUnitSet = new HashSet<String>();
        for (String unit : validUnits) {
            validUnitSet.add(unit);
        }
    }

    
    public static final boolean isValidUnit(String unit) {
        return validUnitSet.contains(unit);
    }

}
