/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.participant;

import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.widgets.Display;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.utils.threads.SWTThread;
import org.simantics.utils.threads.ThreadUtils;

/**
 * A utility participant for accessing the workbench status line.
 * 
 * @author Tuukka Lehtonen
 * 
 * TODO: add scheduled task to remove messages from status bar
 */
public class WorkbenchStatusLine extends AbstractCanvasParticipant {

    private final IStatusLineManager statusLine;

    public WorkbenchStatusLine(IStatusLineManager statusLine) {
        this.statusLine = statusLine;
    }

    public IStatusLineManager getStatusLine() {
        return statusLine;
    }

    public void message(final String message) {
        if (statusLine == null)
            return;

        swtExec(new Runnable() {
            @Override
            public void run() {
                statusLine.setMessage(message);
                statusLine.setErrorMessage(null);
            }
        });
    }

    public void error(final String message) {
        if (statusLine == null)
            return;

        swtExec(new Runnable() {
            @Override
            public void run() {
                statusLine.setErrorMessage(message);
            }
        });
    }

    protected void swtExec(Runnable r) {
        ThreadUtils.asyncExec(SWTThread.getThreadAccess(Display.getDefault()), r);
    }

}
