/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.participant;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.canvas.impl.DependencyReflection.Dependency;
import org.simantics.scenegraph.g2d.events.KeyEvent;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection.EventHandler;
import org.simantics.scenegraph.g2d.events.KeyEvent.KeyPressedEvent;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.scenegraph.g2d.events.command.CommandKeyBinding;
import org.simantics.scenegraph.g2d.events.command.Commands;

/**
 * Converts key presses to commands. 
 * Do not use this in eclipse environment, use XXXTODO instead which
 * converts eclipse commands into g2d commands.
 * 
 * CommandKeyBinding.DEFAULT_BINDINGS
 * 
 * @See {@link CommandKeyBinding} command bindings
 * @See {@link Commands} commands
 * @author Toni Kalajainen
 */
public class KeyToCommand extends AbstractCanvasParticipant {

	@Dependency KeyUtil keyUtil;
	List<CommandKeyBinding> binds = new ArrayList<CommandKeyBinding>();
	
	public KeyToCommand(CommandKeyBinding... binds) {
		assert(binds!=null);
		for (CommandKeyBinding b : binds)
			this.binds.add(b);
	}
	
	public KeyToCommand(Collection<CommandKeyBinding> binds) {
		assert(binds!=null);
		this.binds.addAll(binds);
	}
	
	public void addBinding(CommandKeyBinding binding) {
		if (!this.binds.contains(binding))
			this.binds.add(binding);
	}

	@EventHandler(priority = Integer.MIN_VALUE)
	public boolean handleKeyEvent(KeyEvent e) {
	    //System.out.println("keytocommand " + e);
		boolean pressed = (e instanceof KeyPressedEvent);
		nextBinding:		
		for (CommandKeyBinding ckb : binds) {
			int keyCode = ckb.keyCode[0];
			boolean _down = keyCode>0;
			if (_down != pressed) continue;
			if (!_down) keyCode = -keyCode;			
			if (e.keyCode != keyCode) continue;
			for (int i=1; i<ckb.keyCode.length; i++) {
				int code = ckb.keyCode[i];
				boolean down = code>0;
				if (!down) code = -code;				
				if (keyUtil.isKeyPressed(code) ^ down)
					continue nextBinding;
			}
			CommandEvent ce = new CommandEvent(getContext(), e.time, ckb.command);
			getContext().getEventQueue().queueFirst(ce);
		}
		return false;
	}	
	
}
