/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.elementclass.wheel;

import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.handler.Stateful;
import org.simantics.g2d.element.handler.impl.DefaultTransform;
import org.simantics.g2d.elementclass.PaintableSymbolHandler;
import org.simantics.g2d.image.DefaultImages;

/**
 * @author Toni Kalajainen
 */
public class WheelClass {

	public static final ElementClass WHEEL =
			ElementClass.compile(
					// Pick missing
					DefaultTransform.INSTANCE,
					new RotatorHandler(),
					new PaintableSymbolHandler(DefaultImages.WHEEL),
					Stateful.ENABLED_BY_DEFAULT
					);

}
