/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*******************************************************************************
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.elementclass.valve;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;

import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.g2d.element.handler.LifeCycle;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.element.handler.Stateful;
import org.simantics.g2d.element.handler.Clickable.PressStatus;
import org.simantics.g2d.element.handler.impl.DefaultTransform;
import org.simantics.g2d.element.handler.impl.ElementShapeImpl;
import org.simantics.g2d.element.handler.impl.FillColorImpl;
import org.simantics.g2d.element.handler.impl.FixedSize;
import org.simantics.g2d.elementclass.slider.SliderColorProfile;
import org.simantics.g2d.elementclass.slider.SliderHandle;
import org.simantics.g2d.utils.PathUtils;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.nodes.ShapeNode;
import org.simantics.utils.datastructures.hints.IHintContext.Key;

/**
 * @author Toni Kalajainen
 */
public class ValveClass {

    static final double M = 3;
    public static final Stroke STROKE = new BasicStroke(1.5f);
    public static final Stroke STROKE2 = new BasicStroke(1.f);
    public static final Path2D SHAPE = PathUtils.closedPath(-30*M,20*M, -30*M,-20*M, 0,-7*M, 30*M,-20*M, 30*M,20*M, 0,7*M);
    public static final Path2D WHITE_LINE = PathUtils.path(-30*M,20*M, -30*M,-20*M, 0,-7*M, 30*M,-20*M);
    public static final Path2D BLACK_LINE = PathUtils.path(30*M,-20*M, 30*M,20*M, 0,7*M, -30*M,20*M);
    public final static Rectangle2D TRACK_RECT = new Rectangle2D.Double(-27*M, -5*M, 54*M, 10*M);
    public static final Path2D TRACK_WHITE = PathUtils.path(-27*M,5*M, -27*M,-5*M, 27*M,-5*M);
    public static final Path2D TRACK_BLACK = PathUtils.path(27*M,-5*M, 27*M,5*M, -27*M,5*M);

    public static ElementClass INSTANCE =
        ElementClass.compile(
                new ValvePainter(),
                new ValveHandle(),
                FillColorImpl.handlerOf(new Color(150, 150, 180)),
                //Clickable.INSTANCE,
                Stateful.ENABLED_BY_DEFAULT,
                DefaultTransform.INSTANCE,
                ElementShapeImpl.shapeOf(SHAPE),
                FixedSize.of(SHAPE.getBounds2D())
        );

    public static class ValveHandle extends SliderHandle implements LifeCycle {
        private static final long serialVersionUID = 5605597689550675532L;
        @Override
        protected Rectangle2D getBounds(IElement e) {
            return TRACK_RECT;
        }

        @Override
        protected double getHandleWidth(IElement e) {
            return super.getHandleWidth(e);
        }

        @Override
        public void onElementActivated(IDiagram d, IElement e) {
        }
        @Override
        public void onElementCreated(IElement e) {
            e.setHint(SliderHandle.KEY_SLIDER_COLOR_PROFILE, SliderColorProfile.DEFAULT);
            e.setHint(SliderHandle.KEY_SLIDER_POSITION, 50.0);
            e.setHint(SliderHandle.KEY_SLIDER_MIN_VALUE, 0.0);
            e.setHint(SliderHandle.KEY_SLIDER_MAX_VALUE, 100.0);
        }
        @Override
        public void onElementDeactivated(IDiagram d, IElement e) {
        }
        @Override
        public void onElementDestroyed(IElement e) {
        }

    }


    private static class ValvePainter implements SceneGraph {
        /**
         * 
         */
        private static final long serialVersionUID = -434582053817033874L;
        public static final Key SG_NODE = new SceneGraphNodeKey(Node.class, "SUB_SG_NODE");

        @Override
        public void cleanup(IElement e) {
            Node node = e.removeHint(SG_NODE);
            if (node != null)
                node.remove();
        }

        @Override
        public void init(IElement e, G2DParentNode parent) {
            G2DParentNode node = (G2DParentNode) e.getHint(SG_NODE);
            if (node == null) {
                node = parent.addNode(G2DParentNode.class);
                e.setHint(SG_NODE, node);
            }
            Color 			fc 		= ElementUtils.getFillColor(e);
            PressStatus 	press 	= null;//ElementUtils.getPressStatus(e, ctx); // FIXME: scenegraph does not support context
			AffineTransform at      = ElementUtils.getTransform(e);
			if(at != null) node.setTransform(at);

            ShapeNode shape1 = node.getOrCreateNode("shape1", ShapeNode.class);
            shape1.setStroke(STROKE);
            shape1.setColor(fc);
            shape1.setFill(true);
            shape1.setShape(SHAPE);

            ShapeNode shape_press1 = node.getOrCreateNode("shape_press1", ShapeNode.class);
            ShapeNode shape_press2 = node.getOrCreateNode("shape_press2", ShapeNode.class);

            if (press==null || press==PressStatus.NORMAL || press == PressStatus.HOVER) {
                shape_press1.setColor(Color.WHITE);
                shape_press1.setShape(WHITE_LINE);
                shape_press2.setColor(Color.BLACK);
                shape_press2.setShape(BLACK_LINE);
            } else if (press==PressStatus.PRESSED) {
                shape_press1.setColor(Color.BLACK);
                shape_press1.setShape(WHITE_LINE);
                shape_press2.setColor(Color.WHITE);
                shape_press2.setShape(BLACK_LINE);
            } else if (press==PressStatus.HELD) {
                shape_press1.setColor(new Color(50, 50, 50));
                shape_press1.setShape(WHITE_LINE);
                shape_press2.setColor(new Color(240, 240, 240));
                shape_press2.setShape(BLACK_LINE);
            }

            ShapeNode shape2 = node.getOrCreateNode("shape2", ShapeNode.class);
            shape2.setStroke(STROKE2);
            shape2.setColor(Color.BLACK);
            shape2.setShape(TRACK_BLACK);

            ShapeNode shape3 = node.getOrCreateNode("shape3", ShapeNode.class);
            shape3.setStroke(STROKE2);
            shape3.setColor(Color.WHITE);
            shape3.setShape(TRACK_WHITE);
        }
    }
}
