/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.elementclass.canvas;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.utils.datastructures.hints.IHintContext.Key;
import org.simantics.utils.datastructures.hints.IHintContext.KeyOf;
import org.simantics.utils.page.MarginUtils;
import org.simantics.utils.page.MarginUtils.Margins;

/**
 * Lock viewport (KEY_VIEWPORT) of DiagramPainter to an element.
 * 
 * e.setHint(DiagramHints.KEY_DIAGRAM, ElementUtils.getDiagram(focusE)); Note!
 * Add this handler _before_ diagram painter in element class
 * 
 * Keys: ElementViewport.KEY_ELEMENT
 * 
 * @See {@link DiagramPainter}
 * @author Toni Kalajainen
 */
public class ElementViewport implements SceneGraph {

    public static final Key             KEY_ELEMENT      = new KeyOf(IElement.class);

    private static final long           serialVersionUID = -849879952227051310L;

    public static final ElementViewport INSTANCE         = new ElementViewport();

    private final Margins               margins          = MarginUtils.MARGINS5;

    @Override
    public void cleanup(IElement e) {
    }

    @Override
    public void init(IElement e, G2DParentNode parent) {
        // Initializes viewport before DiagramPainter initializes the
        // scenegraph.
        IElement focusE = e.getHint(KEY_ELEMENT);
        Rectangle2D focusBounds = ElementUtils.getElementBounds(focusE);
        Rectangle2D bounds = ElementUtils.getElementBounds(e);

        AffineTransform at = GeometryUtils.fitArea(bounds, focusBounds, margins);
        e.setHint(DiagramPainter.KEY_VIEWPORT, at);
    }

}
