/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl;

import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.Hover;

/**
 * @author Teemu Lempinen <teemu.lempinen@vtt.fi>
 */
public class HoverImpl implements Hover {

    private static final long serialVersionUID = -9213121907160499031L;

    @Override
    public boolean isHovering(IElement e) {
        return Boolean.TRUE.equals(e.getHint(ElementHints.KEY_HOVER));
    }

    @Override
    public void setHover(IElement e, boolean hover) {
        e.setHint(ElementHints.KEY_HOVER, hover);
    }

}
