/*******************************************************************************
 * Copyright (c) 2017 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler;

import java.util.Map;

import org.simantics.g2d.element.IElement;

/**
 * @author Antti Villberg
 * @since 1.31.0
 */
public interface Parameters extends ElementHandler {

    /**
     * @return A map of element parameters. A <code>null</code> value is allowed
     *         which indicates no parameters.
     */
    Map<String,Object> getParameters(IElement e);

    /**
     * @param p
     *            the parameter map for an element. A <code>null</code> value is
     *            allowed which indicates no parameters.
     */
    void setParameters(IElement e, Map<String,Object> p);

}
