/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.diagram.participant.pointertool;

import org.simantics.g2d.diagram.participant.AbstractDiagramParticipant;
import org.simantics.scenegraph.g2d.events.MouseEvent;

/**
 * @author Toni Kalajainen
 */
public abstract class AbstractMode extends AbstractDiagramParticipant {

    /**
     * ID of the mouse that is used for this mode participant. In a single-mouse
     * setup it will be 0, but may be > 0 in a multi-mouse setup.
     */
    protected int mouseId;

    public AbstractMode(int mouseId) {
        this.mouseId = mouseId;
    }

    public int getMouseId() {
        return mouseId;
    }

    public void setMouseId(int mouseId) {
        this.mouseId = mouseId;
    }

    protected boolean isModeMouse(MouseEvent e) {
        return e.mouseId == mouseId;
    }

}
