/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.diagram.impl;

import java.util.Collection;

import org.simantics.g2d.diagram.DiagramClass;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.impl.Element;
import org.simantics.utils.datastructures.hints.HintContext;

/**
 * @author Toni Kalajainen
 */
public class Diagram extends AbstractDiagram implements IDiagram {

    public static final IDiagram EMPTY_DIAGRAM = spawnNew(DiagramClass.DEFAULT);

    /**
     * Spawn a new diagram to the world
     * @param clazz
     * @return
     */
    public static IDiagram spawnNew(DiagramClass clazz)
    {
        Diagram d = new Diagram(clazz);
        AbstractDiagram.fireCreated(d);
        return d;
    }

    /**
     * Instantiate new diagram for purpose of loading from file...
     * @param clazz
     * @return
     */
    static Diagram instantiate(DiagramClass clazz)
    {
        Diagram d = new Diagram(clazz);
        AbstractDiagram.fireCreated(d);
        return d;
    }

    /**
     * Creates an identical clone of a diagram.
     * @param src
     * @return
     */
    public static IDiagram clone(IDiagram src)
    {
        // Clone diagram
        DiagramClass clazz = src.getDiagramClass();
        Diagram d = new Diagram(clazz);
        // Clone variables
        d.setHints(src.getHints());
        // Clone elements
        for (IElement e : src.getElements())
            d.addElement( Element.clone(e) );

        AbstractDiagram.fireLoaded(d);
        return d;
    }

    /**
     * Creates an identical clone of a diagram.
     * @param src
     * @return
     */
    public static IDiagram clone(IDiagram src, Collection<IElement> elements)
    {
        // Clone diagram
        DiagramClass clazz = src.getDiagramClass();
        Diagram d = new Diagram(clazz);
        // Clone variables
        d.setHints(src.getHints());
        // Clone elements
        for (IElement e : elements) {
            d.addElement( Element.clone(e) );
        }
        AbstractDiagram.fireLoaded(d);

        return d;
    }

    Diagram(DiagramClass clazz)
    {
        super(clazz, new HintContext());
    }

    @Override
    public String toString() {
        String name = getHint(DiagramHints.KEY_TEXT);
        if (name==null) name = super.toString();
        return name;
    }

}
