/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.canvas.impl;

import java.lang.reflect.Method;

import org.simantics.g2d.canvas.IContentContext;
import org.simantics.utils.datastructures.ListenerList;
import org.simantics.utils.threads.CurrentThread;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.SyncListenerList;

/**
 * 
 * @See {@link IContentContext}
 * 
 * @author Toni Kalajainen
 */
public class PaintableContextImpl implements IContentContext {

	@Override
	public void setDirty() {
		fireSetDirty();		
	}
	
	protected ListenerList<IContentListener> list =
        new ListenerList<IContentListener>(IContentListener.class);
	protected SyncListenerList<IContentListener> list2 =
        new SyncListenerList<IContentListener>(IContentListener.class);

	@Override
    public void addPaintableContextListener(IContentListener listener) {
        list.add(listener);
    }
	@Override
    public void addPaintableContextListener(IContentListener listener, IThreadWorkQueue thread) {
		if (thread==CurrentThread.getThreadAccess()) 
			addPaintableContextListener(listener);
		else
			list2.add(thread, listener);
    }    
	@Override
    public void removePaintableContextListener(IContentListener listener) {
        list.remove(listener);
    }
	@Override
    public void removePaintableContextListener(IContentListener listener, IThreadWorkQueue thread) {
		if (thread==CurrentThread.getThreadAccess()) 
			addPaintableContextListener(listener);
		else
			list2.remove(thread, listener);
    }
    private final static Method onDirty = SyncListenerList.getMethod(IContentListener.class, "onDirty");
    protected void fireSetDirty() {
    	for (IContentListener l : list.getListeners())
    		l.onDirty(this);
        list2.fireEventSync(onDirty, this);
    }
    protected void fireAsyncSetDirty() {
        list2.fireEventAsync(onDirty, this);
    }

	
	    
}
