/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.export.core.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.osgi.service.prefs.Preferences;
import org.simantics.databoard.Accessors;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.accessor.RecordAccessor;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.LabelReference;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.forms.DataboardForm;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.util.StreamUtil;
import org.simantics.export.core.ExportContext;
import org.simantics.export.core.error.ExportException;
import org.simantics.export.core.impl.PublisherUtil;
import org.simantics.export.core.intf.PublisherClass;
import org.simantics.export.core.manager.Content;
import org.simantics.export.core.util.ExporterUtils;

public class ZipPublisher
implements PublisherClass {
    private static final String ZIP_EXTENSION = ".zip";
    public static RecordType RT_ZIP;
    public static LabelReference P_ALLOW_OVERWRITE;
    public static LabelReference P_ZIP;

    static {
        P_ALLOW_OVERWRITE = new LabelReference("Overwrite file(s)");
        P_ZIP = new LabelReference("Export to .zip");
        RT_ZIP = new RecordType();
        RT_ZIP.addComponent(ZipPublisher.P_ZIP.label, (Datatype)DataboardForm.fileSaveDialog((String[])new String[]{ZIP_EXTENSION, "*.zip"}));
        RT_ZIP.addComponent(ZipPublisher.P_ALLOW_OVERWRITE.label, (Datatype)Datatypes.BOOLEAN);
    }

    @Override
    public void publish(ExportContext ctx, List<Content> contents, Variant options, Variant locationOptions, IProgressMonitor monitor) throws ExportException {
        Boolean canOverwrite = ExporterUtils.getBoolean(locationOptions, (ChildReference)P_ALLOW_OVERWRITE);
        String zipPath = ExporterUtils.getString(locationOptions, (ChildReference)P_ZIP);
        if (zipPath == null) {
            throw new ExportException("Zip option missing");
        }
        if (canOverwrite == null) {
            throw new ExportException("CanOverwrite option missing");
        }
        File file = new File(zipPath = PublisherUtil.ensureEndsWith(true, ZIP_EXTENSION, zipPath));
        if (file.exists()) {
            if (canOverwrite.booleanValue()) {
                file.delete();
            } else {
                throw new ExportException("Would not overwrite " + file.getAbsolutePath());
            }
        }
        for (Content content : contents) {
            if (content.tmpFile != null) continue;
            throw new ExportException("Internal error, tmpFile was null");
        }
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(file);
                ZipOutputStream zos = new ZipOutputStream(fos);
                for (Content content : contents) {
                    try (FileInputStream fis = new FileInputStream(content.tmpFile);){
                        zos.putNextEntry(new ZipEntry(content.filename));
                        StreamUtil.copyStream((InputStream)fis, (OutputStream)zos);
                        zos.closeEntry();
                    }
                }
                zos.close();
            }
            catch (IOException e) {
                throw new ExportException(e);
            }
        }
        catch (Throwable throwable) {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (fos != null) {
            try {
                fos.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public List<String> validate(ExportContext ctx, List<Content> contents, Variant options, Variant locationOptions) throws ExportException {
        ArrayList<String> result = new ArrayList<String>();
        Boolean canOverwrite = ExporterUtils.getBoolean(locationOptions, (ChildReference)P_ALLOW_OVERWRITE);
        String pathName = ExporterUtils.getString(locationOptions, (ChildReference)P_ZIP);
        if (pathName == null) {
            result.add("Zip option missing?");
            return result;
        }
        if (canOverwrite == null) {
            result.add("CanOverwrite option missing?");
            return result;
        }
        if (pathName.isEmpty()) {
            result.add("Zip must be entered.");
            return result;
        }
        pathName = PublisherUtil.ensureEndsWith(true, ZIP_EXTENSION, pathName);
        File file = new File(pathName);
        if (!canOverwrite.booleanValue() && file.exists()) {
            result.add(String.valueOf(file.getAbsolutePath()) + " already exists.");
        }
        return result;
    }

    @Override
    public RecordType locationOptions(ExportContext ctx, List<Content> contents) throws ExportException {
        return RT_ZIP;
    }

    @Override
    public Variant createLocation(ExportContext ctx, Variant locationOptions) throws ExportException {
        String zipName = ExporterUtils.getString(locationOptions, (ChildReference)P_ZIP);
        if (zipName == null) {
            throw new ExportException("Zip option not found?");
        }
        File file = new File(zipName);
        File path = file.getParentFile();
        if (path == null) {
            return locationOptions;
        }
        if (path.exists() && !path.isDirectory()) {
            throw new ExportException(path + " exists but is not a directory.");
        }
        if (!path.mkdirs()) {
            throw new ExportException("Failed to create " + path);
        }
        return locationOptions;
    }

    @Override
    public boolean locationExists(ExportContext ctx, Variant locationOptions) throws ExportException {
        File path;
        block6: {
            String zipName;
            block5: {
                RecordAccessor ra = (RecordAccessor)Accessors.getAccessor((Variant)locationOptions);
                zipName = (String)ra.getValue((ChildReference)P_ZIP, (Binding)Bindings.STRING);
                if (zipName != null) break block5;
                return false;
            }
            File file = new File(zipName);
            path = file.getParentFile();
            if (path != null) break block6;
            return false;
        }
        try {
            return path.exists() && path.isDirectory();
        }
        catch (AccessorConstructionException e) {
            throw new ExportException(e);
        }
        catch (AccessorException e) {
            throw new ExportException(e);
        }
    }

    @Override
    public void fillDefaultPrefs(ExportContext ctx, List<Content> contents, Variant options, Variant locationOptions) throws ExportException {
        try {
            RecordAccessor ra = (RecordAccessor)Accessors.getAccessor((Variant)locationOptions);
            ra.setValue((ChildReference)P_ALLOW_OVERWRITE, (Binding)Bindings.BOOLEAN, (Object)true);
            ra.setValue((ChildReference)P_ZIP, (Binding)Bindings.STRING, (Object)"");
        }
        catch (AccessorConstructionException e) {
            throw new ExportException(e);
        }
        catch (AccessorException e) {
            throw new ExportException(e);
        }
    }

    @Override
    public void savePref(Variant locationOptions, Preferences contentScopeNode, Preferences workspaceScopeNode) throws ExportException {
        try {
            String s;
            RecordAccessor ra = (RecordAccessor)Accessors.getAccessor((Variant)locationOptions);
            Boolean b = (Boolean)ra.getValue((ChildReference)P_ALLOW_OVERWRITE, (Binding)Bindings.BOOLEAN);
            if (b != null) {
                contentScopeNode.putBoolean(P_ALLOW_OVERWRITE.tail().toString(), b.booleanValue());
                workspaceScopeNode.putBoolean(P_ALLOW_OVERWRITE.tail().toString(), b.booleanValue());
            }
            if ((s = (String)ra.getValue((ChildReference)P_ZIP, (Binding)Bindings.STRING)) != null) {
                contentScopeNode.put(P_ZIP.tail().toString(), s);
            }
        }
        catch (AccessorException e) {
            throw new ExportException(e);
        }
        catch (AccessorConstructionException e) {
            throw new ExportException(e);
        }
    }

    @Override
    public void loadPref(Variant locationOptions, Preferences contentScopePrefs, Preferences workspaceScopePrefs) throws ExportException {
        try {
            String s;
            RecordAccessor ra = (RecordAccessor)Accessors.getAccessor((Variant)locationOptions);
            Boolean b = ExporterUtils.getPrefBoolean(contentScopePrefs, workspaceScopePrefs, P_ALLOW_OVERWRITE.tail().toString());
            if (b != null) {
                ra.setValue((ChildReference)P_ALLOW_OVERWRITE, (Binding)Bindings.BOOLEAN, (Object)b);
            }
            if ((s = ExporterUtils.getPrefString(contentScopePrefs, null, P_ZIP.tail().toString())) != null) {
                ra.setValue((ChildReference)P_ZIP, (Binding)Bindings.STRING, (Object)s);
            }
        }
        catch (AccessorConstructionException e) {
            throw new ExportException(e);
        }
        catch (AccessorException e) {
            throw new ExportException(e);
        }
    }
}

