package org.simantics.export.core.manager;

import java.util.Collections;
import java.util.List;

import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.export.core.ExportContext;
import org.simantics.export.core.error.ExportException;
import org.simantics.export.core.intf.Publisher;
import org.simantics.export.core.util.ExporterUtils;

/**
 * Checks if publish location exists, if not, creates one.
 *
 * @author toni.kalajainen@semantum.fi
 */
public class CreatePublishLocationAction extends ExportAction {

	String publisherId;
	
	public CreatePublishLocationAction(String publisherId) 
	{
		this.publisherId = publisherId;
	}
	
	@Override
	public void execute(ExportContext ctx, IProgressMonitor progress, Variant options) throws ExportException {
		// Get publisher options
		Publisher publisher = ctx.eep.getPublisher( publisherId );
		Variant locationOptions = ExporterUtils.getPublisherLocationOptions(ctx, publisherId, options);
		if ( locationOptions == null ) return;
		boolean exists = publisher.publisherClass().locationExists(ctx, locationOptions);
			
		if ( !exists ) {
			publisher.publisherClass().createLocation(ctx, locationOptions);
		}
	}

	@Override
	public String label(ExportContext ctx) {
		Publisher publisher = ctx.eep.getPublisher( publisherId );
		String label = publisher.label();
		return "Assert "+label+" location exists.";
	}

	@Override
	public int work(ExportContext ctx) {
		return 1;
	}

	@Override
	public List<String> validate(ExportContext ctx, Variant options) {
		return Collections.emptyList();
	}

	@Override
	public void cleanup(ExportContext ctx, IProgressMonitor progress, Variant options) throws ExportException {
	}

}
