package org.simantics.export.core.manager;

import java.io.File;

import org.simantics.databoard.util.URIUtil;

public class Content {

	public String url;
	public String contentTypeId;
	public String formatId;
	public String formatExt; 
	public String label;
	public String modelId;

	/**
	 * Initially suggested and the later used filename.
	 */
	public String filename;
	
	/**
	 * This is an optional field that is filled one export action has been completed.
	 * This value is used by the publisher.
	 */
	public File tmpFile;
	
	public Content(String url, String contentTypeId, String formatId, String label, String formatExt, String modelId) {
		this.url = url;
		this.contentTypeId = contentTypeId;
		this.formatId = formatId;
		this.formatExt = formatExt;
		this.label = label;
		this.modelId = modelId;
		if ( label!=null && formatExt!=null ) {
			String filename = label+formatExt;
			filename = filename.replaceAll("/", "-");
			this.filename = URIUtil.encodeFilename( filename );
		}
	}		
	
	@Override
	public String toString() {
		return "url="+url+",formatId="+formatId;
	}
	
	@Override
	public int hashCode() {
		return url.hashCode()+13*formatId.hashCode();
	}
	
	@Override
	public boolean equals(Object o) {
		if (o == null)
			return false;
		if (o.getClass() != getClass())
			return false;
		Content other = (Content) o;
		if ( !other.formatId.equals(formatId) ) return false;
		if ( !other.url.equals(url) ) return false;
		return true;
	}

}
