package org.simantics.export.core.intf;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.export.core.manager.Content;

/**
 * A resolver for exportable content icons.
 * @author Tuukka Lehtonen
 * @see ContentType#icon(String)
 * @see Content
 */
public interface IconResolver {

	/**
	 * @param input
	 *            String describing content URI or {@link Content} instance
	 * @return ImageDescriptor for input or <code>null</code>
	 */
	ImageDescriptor get(Object input);

	public static class Constant implements IconResolver {

		private ImageDescriptor desc;

		public Constant(ImageDescriptor desc) {
			this.desc = desc;
		}

		@Override
		public ImageDescriptor get(Object input) {
			return desc;
		}

	}

}