package org.simantics.export.core.intf;

import java.util.Collection;
import java.util.Map;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.export.core.ExportContext;
import org.simantics.export.core.error.ExportException;

/**
 * Content Type extension
 *
 * @author toni.kalajainen@semantum.fi
 */
public interface ContentType extends ContentTypeAction {
	
	/**
	 * The identifier for the content type. 
	 * @return
	 */
	String id();
	
	/**
	 * The ui label for the content type.
	 * @return
	 */
	String label();
	
	/**
	 * The ui label for the content type in plural.
	 * @return
	 */
	String plural();

	/**
	 * Content-based icon for a content entity of this content type.
	 * @param content
	 * @return
	 */
	ImageDescriptor icon(String contentUri);

	/**
	 * Fixed icon for the content type
	 * @return (Optional) icon
	 */
	ImageDescriptor icon();		

	/**
	 * Returns true if the content type is a model type.
	 * @return
	 */
	boolean isModel();

	/**
	 * Read labels for a collection of contents
	 * 
	 * @param ctx 
	 * @param contents
	 * @return labels
	 * @throws ExportException if failed to get a label
	 */
	Map<String, String> getLabels( ExportContext ctx, Collection<String> contents ) throws ExportException;

}
