package org.simantics.export.core.impl;


/**
 * @author Tuukka Lehtonen
 */
public class PublisherUtil {

    /**
     * Returns either filePath as is or filePath suffixed by
     * <code>endsWith</code> depending on whether <code>filePath</code> ends
     * with <code>endsWith</code> or not.
     * 
     * @param suffix
     * @param ignoreCase
     * @param filePath
     * @return
     */
    public static String ensureEndsWith(boolean ignoreCase, String suffix, String filePath) {
        int suffixLen = suffix.length();
        int filePathLen = filePath.length();
        if (suffixLen > filePathLen)
            return filePath + suffix;
        if (!filePath.regionMatches(ignoreCase, filePathLen - suffixLen, suffix, 0, suffixLen))
            return filePath + suffix;
        return filePath;
    }

}
