/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.event.view.contribution;

import org.eclipse.jface.resource.FontDescriptor;
import org.simantics.browsing.ui.content.LabelDecorator;
import org.simantics.browsing.ui.model.labeldecorators.LabelDecorationRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.event.ontology.EventResource;
import org.simantics.event.view.Constants;

public enum EventDecorationRule implements LabelDecorationRule
{
    INSTANCE;


    public static EventDecorationRule get() {
        return INSTANCE;
    }

    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }

    public LabelDecorator getLabelDecorator(ReadGraph graph, Object content) throws DatabaseException {
        Resource event = (Resource)content;
        EventResource EVENT = EventResource.getInstance((ReadGraph)graph);
        final boolean milestone = graph.hasStatement(event, EVENT.Milestone);
        final boolean hidden = graph.hasStatement(event, EVENT.Hidden);
        boolean baseline = graph.hasStatement(event, EVENT.EventLog_HasBaselineEvent_Inverse);
        final boolean returnEvent = graph.hasStatement(event, EVENT.ReturnEvent);
        final boolean returnedEvent = graph.hasStatement(event, EVENT.ReturnedBy);
        if (!(milestone || hidden || baseline || returnEvent || returnedEvent)) {
            return null;
        }
        return new LabelDecorator.Stub(){

            public <F> F decorateFont(F font, String column, int itemIndex) {
                int style = 0;
                style |= milestone ? 1 : 0;
                return (F)((style |= hidden ? 2 : 0) != 0 ? ((FontDescriptor)font).setStyle(style) : font);
            }

            public <C> C decorateForeground(C color, String column, int itemIndex) {
                if (returnEvent || returnedEvent) {
                    return (C)Constants.RETURN_EVENT_FG;
                }
                return color;
            }

            public <C> C decorateBackground(C color, String column, int itemIndex) {
                return color;
            }
        };
    }
}

