/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.event.writer;

import org.simantics.databoard.Bindings;
import org.simantics.db.Resource;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.event.ontology.EventResource;
import org.simantics.layer0.Layer0;

/**
 * @author Tuukka Lehtonen
 */
public class NewEvent implements EventWriteTask {

    private final Resource eventInstanceOf;
    private final Resource eventType;
    private final int eventOrderNr;
    private final String componentName;
    private final double time;
    private final String tag;
    private final String message;
    private final boolean eventReturned;

    public NewEvent(Resource eventInstanceOf, Resource eventType, int eventOrderNr, String componentName, double time, String tag, String message, boolean eventReturned) {
        if (eventInstanceOf == null)
            throw new NullPointerException("null event instanceOf");
        this.eventInstanceOf = eventInstanceOf;
        this.eventType = eventType;
        this.eventOrderNr = eventOrderNr;
        this.componentName = componentName;
        this.time = time;
        this.tag = tag;
        this.message = message;
        this.eventReturned = eventReturned;
    }

    @Override
    public Resource write(WriteOnlyGraph graph, Resource slice, int number) throws DatabaseException {
        Layer0 L0 = graph.getService(Layer0.class);
        EventResource EVENT = graph.getService(EventResource.class);

        Resource event = graph.newResource();
        graph.claim(event, L0.InstanceOf, null, eventInstanceOf);

        graph.addLiteral(event, L0.HasName, L0.NameOf, L0.String, ""+number, Bindings.STRING);
        graph.addLiteral(event, EVENT.HasTimestamp, EVENT.HasTimestamp_Inverse, EVENT.TimeStamp, time, Bindings.DOUBLE);
        graph.addLiteral(event, EVENT.Event_sourceName, EVENT.Event_sourceName_Inverse, L0.String, componentName, Bindings.STRING);
        if (eventType != null)
            graph.claim(event, EVENT.Event_type, null, eventType);
        graph.claim(slice, L0.ConsistsOf, L0.PartOf, event);

        graph.addLiteral(event, EVENT.Event_index, EVENT.Event_index_Inverse, L0.Integer, eventOrderNr, Bindings.INTEGER);
        graph.addLiteral(event, EVENT.Event_tag, EVENT.Event_tag_Inverse, L0.String, tag, Bindings.STRING);
        graph.addLiteral(event, EVENT.Event_message, EVENT.Event_message_Inverse, L0.String, message, Bindings.STRING);

        if (eventReturned)
            graph.claim(event, EVENT.ReturnEvent, EVENT.ReturnEvent, event);

        return event;
    }

}
