/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.event.view.handler;

import java.util.List;
import java.util.Map;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.TagUtil;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.request.Read;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ISelectionUtils;

/**
 * @author Tuukka Lehtonen
 */
class PreferenceHandler extends AbstractHandler implements IElementUpdater {

    protected final String virtualGraphId;
    private final String   tagURI;
    private final boolean  tag;

    public PreferenceHandler() {
        this("preferences", null, false);
    }

    public PreferenceHandler(String tagURI, boolean tag) {
        this("preferences", tagURI, tag);
    }

    public PreferenceHandler(String virtualGraphId) {
        this(virtualGraphId, null, false);
    }

    public PreferenceHandler(String virtualGraphId, String tagURI, boolean tag) {
        this.virtualGraphId = virtualGraphId;
        this.tagURI = tagURI;
        this.tag = tag;
    }

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Session session = Simantics.peekSession();
        if (session == null)
            return null;
        ISelection selection = HandlerUtil.getCurrentSelection(event);
        final List<Resource> resources = ISelectionUtils.getPossibleKeys(selection, SelectionHints.KEY_MAIN, Resource.class);
        new TagUtil(virtualGraphId, tagURI, tag) {
            @Override
            protected void processSelection(WriteGraph graph, List<Resource> resources) throws DatabaseException {
                if (!process(graph))
                    return;
                super.processSelection(graph, resources);
            }
        }.execute(session, resources);
        return null;
    }

    /**
     * @return <code>false</code> to perform no further actions after this
     *         method completes.
     */
    protected boolean process(WriteGraph graph) throws DatabaseException {
        return true;
    }

    @SuppressWarnings("rawtypes")
    @Override
    public void updateElement(UIElement element, Map parameters) {
        Session session = Simantics.peekSession();
        if (session == null)
            return;
        try {
            boolean checked = session.syncRequest(new Read<Boolean>() {
                @Override
                public Boolean perform(ReadGraph graph) throws DatabaseException {
                    return isChecked(graph);
                }
            });
            element.setChecked(checked);
        } catch (DatabaseException e) {
            ErrorLogger.defaultLogError(e);
        }
    }

    protected boolean isChecked(ReadGraph graph) throws DatabaseException {
        return false;
    }

}
