package org.simantics.event.view.handler;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.layer0.Layer0;
import org.simantics.utils.ui.ErrorLogger;

/**
 * @author Tuukka Lehtonen
 */
public class ClaimAction extends Action {

    protected final String   virtualGraphId;
    protected final Resource subject;
    protected final String   relationURI;
    protected final Resource object;

    /**
     * @param label
     * @param image
     * @param virtualGraphId
     * @param tagURI
     * @param tag <code>true</code> to add tag, <code>false</code> to remove tag
     * @param input
     */
    public ClaimAction(String label, ImageDescriptor image, String virtualGraphId, Resource subject, String relationURI, Resource object) {
        super(label, image);

        this.virtualGraphId = virtualGraphId;
        this.subject = subject;
        this.relationURI = relationURI;
        this.object = object;
    }

    @Override
    public void run() {
        Session session = Simantics.peekSession();
        if (session != null) {
            VirtualGraph vg = virtualGraphId == null ? null :
                session.getService(VirtualGraphSupport.class).getWorkspacePersistent(virtualGraphId);
            session.asyncRequest(new WriteRequest(vg) {
                @Override
                public void perform(WriteGraph graph) throws DatabaseException {
                    claim(graph);
                }
            }, e -> {
                if (e != null)
                    ErrorLogger.defaultLogError(e);
            });
        }
    }

    public void claim(WriteGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance(graph);
        Resource relation = graph.getResource(relationURI);
        boolean functional = graph.isInstanceOf(relation, L0.FunctionalRelation);
        if (functional)
            graph.deny(subject, relation);
        graph.claim(subject, graph.getResource(relationURI), object);
    }

}
