package org.simantics.document.ui.actions;

import java.io.IOException;

import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.document.DocumentResource;
import org.simantics.graphfile.util.GraphFileUtil;
import org.simantics.layer0.Layer0;

public class NewFileDocument implements ActionFactory {
	Resource relation;
	String defaultName;

	public NewFileDocument(ReadGraph graph, String relationUri, String defaultName) throws DatabaseException {
		relation = graph.getResource(relationUri);
		this.defaultName = defaultName;
	}

	@Override
	public Runnable create(Object target) {

		if(!(target instanceof Resource))
			return null;

		final Resource resource = (Resource)target;

		return new Runnable() {
			@Override
			public void run() {
				Simantics.getSession().asyncRequest(new WriteRequest() {

					@Override
					public void perform(WriteGraph graph) throws DatabaseException {
						create(graph, resource, relation, defaultName);
					}

				});
			}
		};
	}

	public static Resource create(WriteGraph graph, Resource resource, Resource relation, String defaultName) throws DatabaseException {

		graph.markUndoPoint();

		Layer0 l0 = Layer0.getInstance(graph);

		String name = NameUtils.findFreshName(graph, defaultName, resource, relation);
		DocumentResource doc = DocumentResource.getInstance(graph);

		Resource fileResource = graph.newResource();
		graph.claim(fileResource, l0.InstanceOf, doc.FileDocument);
		graph.claimLiteral(fileResource, l0.HasName, name);
		graph.claim(resource, relation, fileResource);
		try {
			GraphFileUtil.writeDataToGraph(graph, new byte[0], fileResource);
		} catch (IOException e) {
			throw new DatabaseException(e);
		}

		return fileResource;

	}

}
