/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.server.request;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.request.UnaryAsyncRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.Read;
import org.simantics.document.server.JSONObject;
import org.simantics.document.server.request.NodeRequest;
import org.simantics.document.server.request.NodesRequest;

public class DocumentRequest
extends VariableRead<List<JSONObject>> {
    public static boolean PROFILE = false;
    public static int PROFILE_THRESHOLD_NODEREQUEST = 2000;
    public static int PROFILE_THRESHOLD_VALUEREQUEST = 500;

    public DocumentRequest(Variable var) {
        super(var);
    }

    public List<JSONObject> perform(ReadGraph graph) throws DatabaseException {
        long s = System.nanoTime();
        Set nodes = (Set)graph.syncRequest((Read)new NodesRequest(this.variable), (AsyncProcedure)TransientCacheAsyncListener.instance());
        if (nodes.isEmpty()) {
            return Collections.emptyList();
        }
        if (PROFILE) {
            long dura = System.nanoTime() - s;
            System.err.println("DocumentRequest1 " + System.identityHashCode((Object)this) + " in " + 1.0E-6 * (double)dura + "ms. " + this.variable.getURI(graph));
        }
        Collection rs = (Collection)graph.syncRequest((AsyncRead)new CollectNodesRequest(nodes));
        if (PROFILE) {
            long dura = System.nanoTime() - s;
            System.err.println("DocumentRequest2 " + System.identityHashCode((Object)this) + " in " + 1.0E-6 * (double)dura + "ms. " + this.variable.getURI(graph));
        }
        ArrayList<JSONObject> result = new ArrayList<JSONObject>(rs);
        Collections.sort(result, new Comparator<JSONObject>(){

            @Override
            public int compare(JSONObject o1, JSONObject o2) {
                return o1.id.compareTo(o2.id);
            }
        });
        if (PROFILE) {
            long dura = System.nanoTime() - s;
            System.err.println("DocumentRequest3 " + System.identityHashCode((Object)this) + " in " + 1.0E-6 * (double)dura + "ms. " + this.variable.getURI(graph));
        }
        return result;
    }

    static class CollectNodesRequest
    extends UnaryAsyncRead<Collection<Variable>, Collection<JSONObject>> {
        public CollectNodesRequest(Collection<Variable> nodes) {
            super(nodes);
        }

        public void perform(AsyncReadGraph graph, AsyncProcedure<Collection<JSONObject>> procedure) {
            final HashSet rs = new HashSet();
            for (Variable node : (Collection)this.parameter) {
                graph.asyncRequest((Read)new NodeRequest(node), (AsyncProcedure)new AsyncProcedure<JSONObject>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void execute(AsyncReadGraph graph, JSONObject result) {
                        HashSet hashSet = rs;
                        synchronized (hashSet) {
                            rs.add(result);
                        }
                    }

                    public void exception(AsyncReadGraph graph, Throwable throwable) {
                    }
                });
            }
            procedure.execute(graph, rs);
        }
    }
}

