/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.server;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.simantics.Simantics;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.document.server.DocumentHistoryListener;
import org.simantics.document.server.JSONObject;
import org.simantics.document.server.request.URIDocumentRequest;
import org.simantics.utils.datastructures.Pair;

public class DocumentHistory {
    public static final int MIN_REFRESHER_THREADS = 1;
    public static final int MAX_REFRESHER_THREADS = 32;
    public static final long DELAY_BETWEEN_UPDATES = 50L;
    public static final long REFRESHER_THREAD_TTL = 10L;
    private ArrayList<Listener<Integer>> listeners = new ArrayList();
    private TreeMap<Integer, JSONObject> entries = new TreeMap();
    private Map<String, Integer> lastRevisions = new THashMap();
    private List<JSONObject> previous = new ArrayList<JSONObject>();
    private int lastRevision = 0;
    private List<JSONObject> incoming;
    private long lastUpdateTime = System.nanoTime();
    private Boolean pending = false;
    private Object pendingChanges = new Object();
    private DocumentHistoryListener updater = null;
    private static ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(null, r, "Document-Refresh-Scheduler");
            t.setDaemon(true);
            return t;
        }
    });
    private static ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 32, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(true), new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(null, r, "Document-Refresher-" + (executor.getPoolSize() + 1));
            t.setDaemon(true);
            return t;
        }
    });

    private static void scheduleRefresh(final Runnable runnable, long delay, TimeUnit unit) {
        Runnable wrapper = new Runnable(){

            @Override
            public void run() {
                executor.execute(runnable);
            }
        };
        scheduler.schedule(wrapper, delay, unit);
    }

    private void pruneListeners() {
        ArrayList<Listener<Integer>> removals = new ArrayList<Listener<Integer>>();
        for (Listener<Integer> listener : this.listeners) {
            if (!listener.isDisposed()) continue;
            removals.add(listener);
        }
        this.listeners.removeAll(removals);
    }

    private void registerListener(Listener<Integer> listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public synchronized boolean hasListeners() {
        this.pruneListeners();
        return !this.listeners.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireListeners(Integer value, Listener<Integer> ignoreListener) {
        ArrayList<Listener<Integer>> currentListeners;
        DocumentHistory documentHistory = this;
        synchronized (documentHistory) {
            currentListeners = new ArrayList<Listener<Integer>>(this.listeners);
        }
        for (Listener<Integer> listener : currentListeners) {
            if (listener.isDisposed()) {
                DocumentHistory documentHistory2 = this;
                synchronized (documentHistory2) {
                    this.listeners.remove(listener);
                    continue;
                }
            }
            if (listener.equals(ignoreListener)) continue;
            listener.execute((Object)value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Integer, Collection<JSONObject>> readChanges(int sequenceNumber) {
        TreeMap<Integer, JSONObject> treeMap = this.entries;
        synchronized (treeMap) {
            ArrayList changes = sequenceNumber < this.lastRevision ? new ArrayList(this.entries.tailMap(sequenceNumber, false).values()) : Collections.emptyList();
            return Pair.make((Object)this.lastRevision, (Object)changes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(List<JSONObject> result) {
        Object object = this.pendingChanges;
        synchronized (object) {
            this.incoming = result;
            if (!this.pending.booleanValue()) {
                this.pending = true;
                long delay = Math.max(0L, this.lastUpdateTime + 50000000L - System.nanoTime());
                DocumentHistory.scheduleRefresh(new RefresherRunnable(), delay, TimeUnit.NANOSECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<Integer, Collection<JSONObject>> flushAndReadChanges(int sequenceNumber, Listener<Integer> ignoreListener) {
        Pair<Integer, Collection<JSONObject>> changes;
        Integer revision = null;
        TreeMap<Integer, JSONObject> treeMap = this.entries;
        synchronized (treeMap) {
            List<JSONObject> update;
            Object object = this.pendingChanges;
            synchronized (object) {
                update = this.incoming;
                this.incoming = null;
            }
            if (update != null) {
                revision = this.refreshInternal(update);
            }
            changes = this.readChanges(sequenceNumber);
        }
        if (revision != null) {
            this.fireListeners(revision, ignoreListener);
        }
        return changes;
    }

    private int refreshInternal(List<JSONObject> result) {
        Set added = null;
        Set removed = null;
        int oldIndex = 0;
        int newIndex = 0;
        while (true) {
            boolean noMoreNews;
            boolean noMoreOlds = oldIndex == this.previous.size();
            boolean bl = noMoreNews = newIndex == result.size();
            if (noMoreOlds) {
                if (noMoreNews) break;
                int i = newIndex;
                while (i < result.size()) {
                    if (added == null) {
                        added = new THashSet();
                    }
                    added.add(result.get(i));
                    ++i;
                }
                break;
            }
            if (noMoreNews) {
                int i = oldIndex;
                while (i < this.previous.size()) {
                    if (removed == null) {
                        removed = new THashSet();
                    }
                    removed.add(this.previous.get(i));
                    ++i;
                }
                break;
            }
            JSONObject o = this.previous.get(oldIndex);
            JSONObject n = result.get(newIndex);
            int comp = o.id.compareTo(n.id);
            if (comp == 0) {
                if (!n.equals((Object)o)) {
                    if (added == null) {
                        added = new THashSet();
                    }
                    added.add(n);
                }
                ++oldIndex;
                ++newIndex;
                continue;
            }
            if (comp > 0) {
                if (added == null) {
                    added = new THashSet();
                }
                added.add(n);
                ++newIndex;
                continue;
            }
            if (comp >= 0) continue;
            if (removed == null) {
                removed = new THashSet();
            }
            removed.add(o);
            ++oldIndex;
        }
        if (added != null) {
            for (JSONObject entry : added) {
                this.add(entry);
            }
        }
        if (removed != null) {
            for (JSONObject entry : removed) {
                this.remove(entry);
            }
        }
        this.previous = result;
        return this.lastRevision;
    }

    private void add(JSONObject entry) {
        Integer rev = this.lastRevisions.get(entry.getId());
        if (rev != null) {
            this.entries.remove(rev);
        }
        ++this.lastRevision;
        this.lastRevisions.put(entry.getId(), this.lastRevision);
        this.entries.put(this.lastRevision, entry);
    }

    private void remove(JSONObject entry) {
        JSONObject object = new JSONObject(entry.getId());
        object.addJSONField("id", entry.getId());
        Integer rev = this.lastRevisions.get(object.getId());
        if (rev != null) {
            this.entries.remove(rev);
        }
        ++this.lastRevision;
        this.lastRevisions.put(object.getId(), this.lastRevision);
        this.entries.put(this.lastRevision, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Integer, Collection<JSONObject>> getContent(Listener<Integer> listener, String location, int sequenceNumber) {
        block14: {
            DocumentHistoryListener newUpdater = null;
            boolean cached = false;
            Object object = this;
            synchronized (object) {
                if (!listener.isDisposed()) {
                    this.registerListener(listener);
                }
                if (this.updater != null && !this.updater.isDisposed()) {
                    cached = true;
                } else if (this.hasListeners()) {
                    newUpdater = this.updater = new DocumentHistoryListener(this);
                }
            }
            if (cached) {
                return this.flushAndReadChanges(sequenceNumber, listener);
            }
            try {
                if (newUpdater != null) {
                    Simantics.getSession().syncRequest((Read)new URIDocumentRequest(location), (Listener)newUpdater);
                    break block14;
                }
                object = this.entries;
                synchronized (object) {
                    List result = (List)Simantics.getSession().syncRequest((Read)new URIDocumentRequest(location), (Listener)TransientCacheListener.instance());
                    this.refreshInternal(result);
                    return this.readChanges(sequenceNumber);
                }
            }
            catch (DatabaseException e) {
                Logger.defaultLogError((Throwable)e);
            }
        }
        return this.flushAndReadChanges(sequenceNumber, listener);
    }

    protected void removeUpdater() {
        this.updater = null;
    }

    private class RefresherRunnable
    implements Runnable {
        private RefresherRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Integer revision = null;
            TreeMap<Integer, JSONObject> treeMap = DocumentHistory.this.entries;
            synchronized (treeMap) {
                List<JSONObject> update;
                Object object = DocumentHistory.this.pendingChanges;
                synchronized (object) {
                    update = DocumentHistory.this.incoming;
                    DocumentHistory.this.incoming = null;
                }
                if (update != null) {
                    revision = DocumentHistory.this.refreshInternal(update);
                }
                object = DocumentHistory.this.pendingChanges;
                synchronized (object) {
                    if (DocumentHistory.this.incoming != null) {
                        DocumentHistory.scheduleRefresh(new RefresherRunnable(), 50L, TimeUnit.MILLISECONDS);
                    } else {
                        DocumentHistory.this.pending = false;
                        if (update != null) {
                            DocumentHistory.this.lastUpdateTime = System.nanoTime();
                        }
                    }
                }
            }
            if (revision != null) {
                DocumentHistory.this.fireListeners(revision, null);
            }
        }
    }
}

