package org.simantics.document.server.request;

import gnu.trove.set.hash.THashSet;

import java.util.Collections;
import java.util.Set;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.document.base.ontology.DocumentationResource;

public class NodesRequest2 extends VariableRead<Set<Variable>> {

    public NodesRequest2(Variable var) {
        super(var);
	}

	@Override
	public Set<Variable> perform(ReadGraph graph) throws DatabaseException {
	    
		DocumentationResource DOC = DocumentationResource.getInstance(graph);

		Resource type = variable.getPossibleType(graph);
		if(type == null) return Collections.emptySet();
		
		if(!graph.isInheritedFrom(type, DOC.Components_Component)) return Collections.emptySet();

		Boolean pathExists = variable.getPossiblePropertyValue(graph, DOC.Properties_pathExists, Bindings.BOOLEAN);
		if(pathExists != null && !pathExists) return Collections.emptySet();

		if(graph.isInheritedFrom(type, DOC.Components_PrimitiveComponent)) {
			return Collections.singleton(variable);
		} else {
			Set<Variable> result = new THashSet<Variable>();
			for(Variable child : variable.getChildren(graph)) {
				Set<Variable> nodes = graph.syncRequest(new NodesRequest2(child));
				result.addAll(nodes);
			}
	        
			return result;
		}

	}

}