package org.simantics.document.server;

import org.simantics.document.server.io.IConsole;
import org.simantics.scl.runtime.reporting.SCLReportingHandler;

public class ConsoleSCLReportingHandler implements SCLReportingHandler {

	private static final boolean PRINT_TO_IDE = true;
	
	private final IConsole console;

	public ConsoleSCLReportingHandler(IConsole console) {
		this.console = console;
	}

	@Override
	public void print(String text) {
		if(PRINT_TO_IDE) System.err.println("simupedia console print: " + text);
		console.addMessage(text);
	}

	@Override
	public void printError(String error) {
		if(PRINT_TO_IDE) System.err.println("simupedia console print error: " + error);
		console.addMessage(error);
	}

	@Override
	public void printCommand(String command) {
		if(PRINT_TO_IDE) System.err.println("simupedia console print command: " + command);
		console.addMessage(command);
	}

	@Override
	public void didWork(double amount) {
		console.addMessage("didWork " + amount);
	}

}