package org.simantics.document.linking.report.html;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

import org.simantics.document.linking.report.Table;
import org.simantics.document.linking.report.TableColumn;
import org.simantics.document.linking.report.TextItem;
import org.simantics.document.linking.report.TableColumn.Alignment;
import org.simantics.document.linking.report.TableRow;


public class HTMLTable extends HTMLTextElement implements Table {
	HTMLDocument writer;
	
	List<TableColumn> columns = new ArrayList<TableColumn>();
	
	boolean linesVisible = true;
	boolean headerVisible = true;
	TextItem title = null;
	int currentLine = 0;
	PrintStream os;
	
	String classID;
	
	boolean copyStyle = false;
	
	public HTMLTable(HTMLDocument writer, boolean id) {
		super(id == false ? null : writer.getUniqueId(HTMLTable.class));
		this.writer = writer;
		this.os = writer.os;
		this.classID = writer.getUniqueId(this);
	}
	
	public HTMLTable(HTMLDocument writer, PrintStream os, boolean id) {
		super(id == false ? null : writer.getUniqueId(HTMLTable.class));
		this.writer = writer;
		this.os = os;
		this.classID = writer.getUniqueId(this);
	}
	
	public HTMLTable(HTMLTable table, boolean id) {
		super(id == false ? null : table.writer.getUniqueId(HTMLTable.class));
		this.writer = table.writer;
		this.os = table.os;
		this.columns.addAll(table.columns);
		this.classID = table.classID;
		this.copyStyle = true;
	}
	
	@Override
	public TableColumn addColumn(String name, double width) {
		TableColumn tc = new TableColumn(name, width);
		columns.add(tc);
		return tc;
	}
	
	@Override
	public List<TableColumn> getColumns() {
		return columns;
	}
	
	@Override
	public void setTitle(String title) {
		try {
			this.title = writer.newItem(TextItem.class);
			this.title.setText(title);
		} catch (Exception e) {
			
		}
	}
	
	@Override
	public void setTitle(TextItem title){
		this.title = title;
	}
	
	@Override
	public TableRow writeRow(String... line) throws Exception {
		List<String> list = new ArrayList<String>(line.length);
		for (String s : line)
			list.add(s);
		return writeRow(list);
	}
	
	@Override
	public TableRow writeRow(List<String> line) throws Exception {
		for (int i = 0; i < line.size(); i++) {
			line.set(i, escape(line.get(i)));
		}
		return writeRowRaw(line);
	}
	
	@Override
	public TableRow writeRowItem(List<TextItem> line) throws Exception {
		for (int i = 0; i < line.size(); i++) {
			TextItem text = line.get(i);
			if (text != null) {
				text.setText(escape(text.getText()));
			}
		}
		return writeRowRaw2(line);
	}
	
	@Override
	public TableRow writeRowItem(TextItem... line) throws Exception {
		List<TextItem> list = new ArrayList<TextItem>(line.length);
		for (TextItem s : line)
			list.add(s);
		return writeRowItem(list);
	}
	
	
	public TableRow writeRowRaw(List<String> line) throws Exception {
		if (currentLine == 0)
			startTable();
		String clz = "\""; //$NON-NLS-1$
		clz += currentLine % 2 == 0 ? "even" : "odd"; //$NON-NLS-1$ //$NON-NLS-2$
		clz += " "+currentTextSize; //$NON-NLS-1$
		clz += "\""; //$NON-NLS-1$
		os.println("    <tr class=" + clz+ ">"); //$NON-NLS-1$ //$NON-NLS-2$
		if (line.size() > 1) {
			for (int i = 0; i < line.size(); i++) {
				String s = line.get(i);
				Alignment a = columns.get(i).getAlignment();
				String tdClass = "class=\"" +a.toString()+"\""; //$NON-NLS-1$ //$NON-NLS-2$
				
				if (s != null)
					os.println("      <td "+tdClass+">" + s + "</td>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				else
					os.println("      <td> </td>"); //$NON-NLS-1$
			}
		} else if (line.size() == 1){
			String s = line.get(0);
			Alignment a = columns.get(0).getAlignment();
			String tdClass = "class=\"" +a.toString()+"\""; //$NON-NLS-1$ //$NON-NLS-2$
			if (s != null)
				os.println("      <td "+tdClass + " colspan=\"" + columns.size()+"\">" + s + "</td>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			else
				os.println("      <td colspan=\"" + columns.size()+"\"> </td>"); //$NON-NLS-1$ //$NON-NLS-2$
			
		} else {
			os.println("      <td colspan=\"" + columns.size()+"\"> </td>"); //$NON-NLS-1$ //$NON-NLS-2$
		}
		os.println("    </tr>"); //$NON-NLS-1$
		currentLine++;
		writer.currentLine++;
		return new HTMLTableRow(null);
	}
	
	public TableRow writeRowRaw2(List<TextItem> line) throws Exception {
		if (currentLine == 0)
			startTable();
		String clz = "\""; //$NON-NLS-1$
		clz += currentLine % 2 == 0 ? "even" : "odd"; //$NON-NLS-1$ //$NON-NLS-2$
		clz += " "+currentTextSize; //$NON-NLS-1$
		clz += "\""; //$NON-NLS-1$
		os.println("    <tr class=" + clz+ ">"); //$NON-NLS-1$ //$NON-NLS-2$
		if (line.size() > 1) {
			for (int i = 0; i < line.size(); i++) {
				TextItem item = line.get(i);
				Alignment a = columns.get(i).getAlignment();
				String tdClass = "class=\"" +a.toString()+"\""; //$NON-NLS-1$ //$NON-NLS-2$
				
				if (item != null && item.getText() != null)
					os.println("      <td "+tdClass+">" + item.toString() + "</td>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				else
					os.println("      <td> </td>"); //$NON-NLS-1$
			}
		} else if (line.size() == 1){
			String s = line.get(0).toString();
			Alignment a = columns.get(0).getAlignment();
			String tdClass = "class=\"" +a.toString()+"\""; //$NON-NLS-1$ //$NON-NLS-2$
			if (s != null)
				os.println("      <td "+tdClass + " colspan=\"" + columns.size()+"\">" + s + "</td>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			else
				os.println("      <td colspan=\"" + columns.size()+"\"> </td>"); //$NON-NLS-1$ //$NON-NLS-2$
			
		} else {
			os.println("      <td colspan=\"" + columns.size()+"\"> </td>"); //$NON-NLS-1$ //$NON-NLS-2$
		}
		os.println("    </tr>"); //$NON-NLS-1$
		currentLine++;
		writer.currentLine++;
		return new HTMLTableRow(null);
	}

	@Override
	public boolean isLinesVisible() {
		return linesVisible;
	}
	
	@Override
	public void setLinesVisible(boolean b) {
		this.linesVisible = b;
	}
	
	@Override
	public boolean isHeaderVisible() {
		return headerVisible;
	}
	
	@Override
	public void setHeaderVisible(boolean b) {
		this.headerVisible = b;
	}
	
	void style() {
		for (int i = 0; i < columns.size(); i++) {
			os.println("table."+classID+" th.column"+i+" {"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			os.println("  width: " + ((int)(columns.get(i).getWidth()*100.0)) + "%;"); //$NON-NLS-1$ //$NON-NLS-2$
			os.println("}"); //$NON-NLS-1$
		}
	}
	
	void startTable() {
		
		if (id != null) {
			os.println("<a id=\"" + id + "\"></a>"); //$NON-NLS-1$ //$NON-NLS-2$
		}	
		String clz = classID + " " + (linesVisible ? "lines" : "nolines"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		os.println("<table class=\"" + clz +"\" >"); //$NON-NLS-1$ //$NON-NLS-2$
		
		if (headerVisible) {
			if (title != null)
				os.println("  <caption>"+title+"</caption>"); //$NON-NLS-1$ //$NON-NLS-2$
			os.println("  <thead>"); //$NON-NLS-1$
			os.println("    <tr class=MEDIUM>"); //$NON-NLS-1$
			int ci = 0;
			for (TableColumn c : columns) {
			   os.println("      <th class=\"column" + ci +"\">" + escape(c.getName()) + "</th>"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			   ci++;
			}
			os.println("    </tr>"); //$NON-NLS-1$
			os.println("  </thead>"); //$NON-NLS-1$
		}
		os.println("  <tbody>"); //$NON-NLS-1$
	}
	
	void endTable() throws Exception{
		if (currentLine > 0) {
			os.println("  </tbody>"); //$NON-NLS-1$
			os.println("</table>"); //$NON-NLS-1$
			os.println("<br>"); //$NON-NLS-1$
			if (!copyStyle) {
				os.println("<style>"); //$NON-NLS-1$
				style();
				os.println("</style>"); //$NON-NLS-1$
			}
		}
	}
	
	private String escape(String s) {
		// TODO : escape string
		return s;
	}
	
	
}
