package org.simantics.document.linking.report.html;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;

/**
 * Base class for single HTML stream.
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */

public class HTMLStreamElement implements HTMLElement{
	
	protected HTMLStreamElement parent;
	protected File file;
	protected PrintStream os;
	
	public HTMLStreamElement(File file) throws Exception{
		parent = null;
		this.file = file;
		os = new PrintStream(file,"UTF-8"); //$NON-NLS-1$
	}
	
	public HTMLStreamElement(HTMLStreamElement parent) throws Exception{
		this.parent = parent;
		openStream();
	}
	
	private void openStream() throws IOException {
		file = File.createTempFile("report_content", ".html"); //$NON-NLS-1$ //$NON-NLS-2$
		os = new PrintStream(file,"UTF-8"); //$NON-NLS-1$
	}
	

	protected void copyData(File source, PrintStream dest)throws Exception {
		BufferedInputStream is = new BufferedInputStream(new FileInputStream(source));
		while (true) {
			int read = is.read();
			if (read == -1)
				break;
			dest.write(read);
		}
		is.close();
	}
	
	public PrintStream getPrintStream() {
		return os;
	}
	
	/**
	 * Closes the stream and copies the contents to the parent stream.
	 * @throws Exception
	 */
	public void close() throws Exception {
		os.flush();
		os.close();
		if (parent != null) {
			copyData(file, parent.os);
			file.delete();
		}
		os = null;
	}
	
	@Override
	public String getId() {
		return null;
	}
}
