package org.simantics.document.linking.report.evaluator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.document.linking.Activator;
import org.simantics.document.linking.ontology.DocumentLink;
import org.simantics.document.linking.report.DocumentLine;
import org.simantics.objmap.graph.annotations.OrderedSetType;

/**
 * Combines child node contents to separate lines.
 * 
 * If all children return null, the return value is null.
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
@OrderedSetType(DocumentLink.URIs.EvaluatorTree_Lines)
public class Lines extends EvaluatorNode {

	
	@Override
	public String getValue(ReadGraph graph, Variable variable, Map<Object, Object> context) throws DatabaseException {
		String s = ""; //$NON-NLS-1$
		for (int i = 0 ; i < children.size(); i++) {
			String s2 = children.get(i).getValue(graph, variable, context);
			if (s2 != null) {
				s+= s2;
				if (i < children.size()-1)
					s+=System.getProperty("line.separator"); //$NON-NLS-1$
			}
		}
		if (s.length() == 0)
			return null;
		return s;
	}
	

	@Override
	public String toString() {
		return "Lines" ; //$NON-NLS-1$
	}
	
	
	
	@Override
	public List<DocumentLine> getLines(ReadGraph graph,	Variable variable, Map<Object, Object> context) throws DatabaseException {
		List<DocumentLine> result = new ArrayList<DocumentLine>();
		for (int i = 0 ; i < children.size(); i++) {
			result.addAll(children.get(i).getLines(graph, variable, context));
		}
		return result;
	}
	
	@Override
	public EvaluatorItem copy() {
		Lines lines = new Lines();
		copyChildren(lines);
		return lines;
	}
	
	@Override
	public ImageDescriptor getImage() {
		return Activator.imageDescriptorFromPlugin("com.famfamfam.silk", "icons/text_linespacing.png"); //$NON-NLS-1$ //$NON-NLS-2$
	}

}
