package org.simantics.document.linking.report;

import java.awt.Font;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.document.linking.Activator;
import org.simantics.document.linking.report.html.HTMLDocument;
import org.simantics.document.linking.report.pdf.PDFDocument;
import org.simantics.document.linking.report.templates.CompleteStructureWriter;
import org.simantics.document.linking.report.templates.DocumentStructureWriter;
import org.simantics.document.linking.report.templates.ReportWriter;


public class ExportToPDF {
	public static final int DOCUMENT_BROWSE_STRCTURE = 0;
	public static final int DOCUMENT_STRUCTURE = 1;
	public static final int DIAGRAM_STRUCTURE = 2;
	public static final int COMPLETE_STRUCTURE = 3;
	
	private Session session;
	private Resource model;
	
	public ExportToPDF(Session session,Resource model) {
		this.model = model;
		this.session = session;
	}
	
	public  void exportPDF(String filename, int report) {
		ReportWriter<?> reportWriter = null;
		switch (report) {
		case DOCUMENT_BROWSE_STRCTURE:
			
			break;
		case DOCUMENT_STRUCTURE:
			reportWriter = new DocumentStructureWriter();
			break;
		case DIAGRAM_STRUCTURE:
			
			break;
		case COMPLETE_STRUCTURE:
			reportWriter = new CompleteStructureWriter();
			break;
		default:
			break;
		}
		ExportJob job = new ExportJob(filename, reportWriter);
		job.setUser(true);
		job.schedule();
		
	}
	
	private class ExportJob extends Job {
		
		String filename;
		ReportWriter<?> reportWriter;
		
		public ExportJob(String filename, ReportWriter<?> reportWriter) {
			super(reportWriter.getName());
			this.filename = filename;
			this.reportWriter = reportWriter;
		}
		
		@Override
		protected IStatus run(IProgressMonitor monitor) {
			return export(filename, reportWriter, monitor);
		}
	}
	
	public <T> IStatus export(String filename, ReportWriter<T> reportWriter, IProgressMonitor monitor) {
		
		Document lineWriter = null;
		try {
			if (filename.toLowerCase().endsWith(".pdf")) //$NON-NLS-1$
				lineWriter = new PDFDocument(filename, new Font("Arial", Font.PLAIN, 10),new Font("Arial", Font.BOLD, 10)); //$NON-NLS-1$ //$NON-NLS-2$
			else if (filename.toLowerCase().endsWith(".html") || //$NON-NLS-1$
					filename.toLowerCase().endsWith(".htm")) //$NON-NLS-1$
				lineWriter = new HTMLDocument(new File(filename));
			else {
				throw new Exception("File has unknow extension " + filename); //$NON-NLS-1$
			}
			export(lineWriter, reportWriter, monitor);
			
		} catch (Exception e) {
			return new Status(IStatus.ERROR, Activator.PLUGIN_ID, Messages.ExportToPDF_ActivatorCouldNotGenerateReport, e);
		} finally {
			if (lineWriter != null) {
				try {
					lineWriter.close();
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
			
		}
		String status  = Messages.ExportToPDF_ReportGenerated;
//		if (lineWriter instanceof PDFTableWriter) {
//			status += " Report size " + ((PDFTableWriter)lineWriter).getCurrentPageIndex() + " pages.";
//		}
		
		return new Status(IStatus.OK, Activator.PLUGIN_ID, status);
	}
	
	

	
	private <T> void export(final Document document, final ReportWriter<T> reportWriter, final IProgressMonitor monitor) throws DatabaseException{
		session.syncRequest(new Read<Object>() {
			@Override
			public Object perform(ReadGraph graph) throws DatabaseException {
				
				try {
					Map<Object, Object> context = new HashMap<Object, Object>();
					context.put("model", model); //$NON-NLS-1$
					context.put(Document.class, document);
					context.put(ReportWriter.class, reportWriter);
					context.put("DocumentName", reportWriter.getName()); //$NON-NLS-1$
					
					reportWriter.start(graph, model, document, context);
					
					List<T> list = reportWriter.getReportItems(graph);
					
			        monitor.beginTask(Messages.ExportToPDF_MonitorWriteReport, list.size());
	
			        T previous = null;
			        T current = null;
			        T next = null;
			        for (int i = 0; i < list.size(); i++) {
			        	current = list.get(i);
			        	if (i > 0)
			        		previous = list.get(i-1);
			        	else
			        		previous = null;
			        	if (i < list.size()-1)
			        		next = list.get(i+1);
			        	else
			        		next = null;
			        	reportWriter.write(previous, current, next, document);
			        	monitor.worked(1);
			        }
				} catch (Exception e) {
					throw new DatabaseException(e);
				}
		        monitor.done();
		        return null;
 			}
		});
		
	}
	
	public static void exportDocumentToPDF(Resource model, String filename) {
	    ExportToPDF exportPdf = new ExportToPDF(Simantics.getSession(), model);
	    exportPdf.export(filename, new DocumentStructureWriter(), new NullProgressMonitor());
	}
}
