package org.simantics.document.linking.report;

import java.util.HashMap;
import java.util.Map;

public class DocumentLine {
	
	String line;
	
	Map<Object, Object> hints;
	
	public DocumentLine() {
		hints = new HashMap<Object, Object>();
	}
	
	public DocumentLine(String line, Map<Object,Object> hints) {
		this.line = line;
		this.hints = hints;
	}
	
	public DocumentLine(String line, Object...hints) {
		this.line = line;
		this.hints = new HashMap<Object, Object>();
		for (int i = 0; i < hints.length; i+=2) {
			this.hints.put(hints[i], hints[i+1]);
		}
	}
	
	
	public String getLine() {
		return line;
	}
	
	public Map<Object, Object> getHints() {
		return hints;
	}

}
