package org.simantics.document.linking.ge;

import org.eclipse.swt.widgets.Display;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.document.linking.ontology.DocumentLink;
import org.simantics.document.linking.utils.SourceLinkUtil;
import org.simantics.ui.workbench.editor.EditorAdapter;
import org.simantics.ui.workbench.editor.EditorRegistry;
import org.simantics.utils.ui.ExceptionUtils;

public class ShowDocumentAction implements ActionFactory{
	
	
	@Override
	public Runnable create(Object target) {
		if (!(target instanceof Variable))
			return null;
		final Variable v = (Variable)target;
		

		return new Runnable() {
			
			@Override
			public void run() {
				Simantics.getSession().asyncRequest(new ReadRequest() {
					
					@Override
					public void run(ReadGraph graph) throws DatabaseException {
						DocumentLink sl = DocumentLink.getInstance(graph);
						Resource t = v.getPossibleRepresents(graph);
						if (!graph.isInstanceOf(t, sl.Source))
							return;
						final Resource reference = SourceLinkUtil.getReferredDocument(graph, t);
						if (reference == null)
							return;
						EditorAdapter[] adapters = EditorRegistry.getInstance().getAdaptersFor(graph, reference);
						if (adapters.length == 0)
							return;
						EditorAdapter highPri = null;
						int pri = Integer.MIN_VALUE;
						for (EditorAdapter a : adapters) {
							int p = a.getPriority();
							if (highPri == null || p > pri) {
								highPri = a;
								pri = p;
							} 
						}
						final EditorAdapter adapter = highPri;
						Display.getDefault().asyncExec(new Runnable() {
							
							@Override
							public void run() {
								try {
									adapter.openEditor(reference);
								} catch (Exception e) {
									ExceptionUtils.logAndShowError(Messages.ShowDocumentAction_CannotOpenEditor, e);
								}
							}
						});

						
					}
				});
				
			}
		};

		
	}

}
