package org.simantics.document.linking.ge;

import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.document.linking.utils.SourceLinkUtil;


public class ReplaceWithLatestAction implements ActionFactory{
	
	
	@Override
	public Runnable create(Object target) {
		if (!(target instanceof Variable))
			return null;
		final Variable v = (Variable)target;
		

		return new Runnable() {
			
			@Override
			public void run() {
				Simantics.getSession().asyncRequest(new WriteRequest() {
					
					@Override
					public void perform(WriteGraph graph) throws DatabaseException {
					    graph.markUndoPoint();
						Resource t = v.getPossibleRepresents(graph);
						SourceLinkUtil.updateToLatest(graph, t);
						
					}
				});
				
			}
		};

		
	}

}
