package org.simantics.document.linking.ge;

import java.util.ArrayList;
import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.StandardGraphChildVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.document.linking.ontology.DocumentLink;
import org.simantics.layer0.Layer0;

/**
 * Rule for browsing all document links in a model.
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public class ModelChildRule implements org.simantics.browsing.ui.model.children.ChildRule{
	
	private ObjectChildRule objectChildRule;
	private PropertyChildRule propertyChildRule;
	private boolean showOnlyCheckable = false; // show only removed old old links
	
	public ModelChildRule(ReadGraph graph, Resource r) {
		DocumentLink sl = DocumentLink.getInstance(graph);
		showOnlyCheckable = sl.ModelViewpointBrowseContext2_ChildRule.equals(r);
		objectChildRule = new ObjectChildRule();
		propertyChildRule = new PropertyChildRule(false);
		objectChildRule.setShowOnlyCheckable(showOnlyCheckable);
		propertyChildRule.setShowOnlyCheckable(showOnlyCheckable);
	}
	
	@Override
	public boolean isCompatible(Class<?> contentType) {
		return contentType.equals(Resource.class) || contentType.equals(Variable.class);
	}
	
	@Override
	public Collection<?> getChildren(ReadGraph graph, Object obj)
			throws DatabaseException {

		ArrayList<Object> children = new ArrayList<Object>();
		

		Resource resource = null;
		Variable variable = null;
		if (obj instanceof Resource) {
			resource = (Resource)obj;
			try {
				variable = graph.adapt(resource, Variable.class);
			} catch (Throwable t) {
				return children;
			}
			children.add(new StandardGraphChildVariable(variable,null,  resource));
			return children;
		} else {
			variable = (Variable)obj;
			resource = variable.getPossibleRepresents(graph);
		}
		
	
		DocumentLink sl = DocumentLink.getInstance(graph);
		if (graph.isInstanceOf(resource, sl.Source))
			return children;
		Layer0 l0 = Layer0.getInstance(graph);
//		children.addAll(graph.getObjects(resource, l0.ConsistsOf));
		for (Resource  r : graph.getObjects(resource, l0.ConsistsOf)) {
			Variable v = new StandardGraphChildVariable(variable,null,  r);
			if (hasLinkedChildren(graph, v))
				children.add(v);
		}
		children.addAll(objectChildRule.getChildren(graph, variable));
		children.addAll(propertyChildRule.getChildren(graph, variable));
		

		return children;
	}
	
	private boolean hasLinkedChildren(ReadGraph graph, Variable variable) throws DatabaseException {
		if (getLinkChildren(graph, variable).size() > 0)
			return true;
		Collection<Variable> children = getObjectChildren(graph, variable);
		if (children.size() == 0)
			return false;
		
		for (Variable child : children) {
			if (hasLinkedChildren(graph, child))
				return true;
		}
		return false;
			
	}
	
	private Collection<Variable> getObjectChildren(ReadGraph graph, Variable variable) throws DatabaseException{
		ArrayList<Variable> children = new ArrayList<Variable>();
		Layer0 l0 = Layer0.getInstance(graph);
		for (Resource  r : graph.getObjects(variable.getRepresents(graph), l0.ConsistsOf)) {
			children.add(new StandardGraphChildVariable(variable,null, r));
		}
		return children;
	}
	
	private Collection<?> getLinkChildren(ReadGraph graph, Variable variable) throws DatabaseException{
		ArrayList<Object> children = new ArrayList<Object>();
		children.addAll(objectChildRule.getChildren(graph, variable));
		children.addAll(propertyChildRule.getChildren(graph, variable));
		return children;
	}
	
	@Override
	public Collection<?> getParents(ReadGraph graph, Object child)
			throws DatabaseException {
		return new ArrayList<Resource>();
	}

}
