/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.synchronization.graph;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.Resource;
import org.simantics.diagram.synchronization.IModificationQueue;
import org.simantics.diagram.synchronization.ISynchronizationContext;
import org.simantics.diagram.synchronization.graph.BasicResources;
import org.simantics.diagram.synchronization.graph.GraphSynchronizationHints;
import org.simantics.diagram.synchronization.graph.PropertyModification;
import org.simantics.diagram.synchronization.graph.ResourceSynchronizer;
import org.simantics.g2d.element.ElementHints;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintObservable;

public class TransformSynchronizer
extends ResourceSynchronizer {
    public static final TransformSynchronizer INSTANCE = new TransformSynchronizer();
    private static final IHintContext.Key[] SYNCHRONIZED_HINTS = new IHintContext.Key[]{ElementHints.KEY_TRANSFORM, ElementHints.KEY_BOUNDS};

    @Override
    public IHintContext.Key[] getSynchronizedHints() {
        return SYNCHRONIZED_HINTS;
    }

    @Override
    public boolean hintChanged(ISynchronizationContext context, IModificationQueue queue, Resource object, IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
        if (newValue == null) {
            return false;
        }
        if (ElementHints.KEY_TRANSFORM.equals(key)) {
            BasicResources br = (BasicResources)context.get(GraphSynchronizationHints.BASIC_RESOURCES);
            double[] flatmatrix = new double[6];
            ((AffineTransform)newValue).getMatrix(flatmatrix);
            return queue.offer(new PropertyModification(object, br.DIA.HasTransform, br.G2D.Transform, flatmatrix, (Binding)Bindings.DOUBLE_ARRAY), null);
        }
        if (ElementHints.KEY_BOUNDS.equals(key)) {
            BasicResources br = (BasicResources)context.get(GraphSynchronizationHints.BASIC_RESOURCES);
            double[] flatmatrix = new double[]{((Rectangle2D)newValue).getMinX(), ((Rectangle2D)newValue).getMinY(), ((Rectangle2D)newValue).getWidth(), ((Rectangle2D)newValue).getHeight()};
            return queue.offer(new PropertyModification(object, br.G2D.HasBounds, br.G2D.Rectangle2D, flatmatrix, (Binding)Bindings.DOUBLE_ARRAY), null);
        }
        return false;
    }
}

