/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.symbollibrary.ui;

import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.AcceptAllFilter;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.nebula.widgets.pgroup.PGroup;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ExpandEvent;
import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.ListenerAdapter;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.internal.Activator;
import org.simantics.diagram.symbolcontribution.CompositeSymbolGroup;
import org.simantics.diagram.symbolcontribution.IIdentifiedObject;
import org.simantics.diagram.symbolcontribution.ISymbolProvider;
import org.simantics.diagram.symbolcontribution.SymbolProviderFactory;
import org.simantics.diagram.symbollibrary.IModifiableSymbolGroup;
import org.simantics.diagram.symbollibrary.ISymbolGroup;
import org.simantics.diagram.symbollibrary.ISymbolGroupListener;
import org.simantics.diagram.symbollibrary.ISymbolItem;
import org.simantics.diagram.symbollibrary.ui.DefaultFilterStrategy;
import org.simantics.diagram.symbollibrary.ui.FilterArea;
import org.simantics.diagram.symbollibrary.ui.FilterConfiguration;
import org.simantics.diagram.symbollibrary.ui.GroupFilter;
import org.simantics.diagram.synchronization.ErrorHandler;
import org.simantics.diagram.synchronization.LogErrorHandler;
import org.simantics.diagram.synchronization.SynchronizationHints;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.chassis.AWTChassis;
import org.simantics.g2d.diagram.DiagramUtils;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.PickContext;
import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.diagram.handler.layout.FlowLayout;
import org.simantics.g2d.diagram.participant.AbstractDiagramParticipant;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.diagram.participant.pointertool.PointerInteractor;
import org.simantics.g2d.dnd.IDragSourceParticipant;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.StaticSymbol;
import org.simantics.g2d.event.adapter.SWTMouseEventAdapter;
import org.simantics.g2d.gallery.GalleryViewer;
import org.simantics.g2d.gallery.ILabelProvider;
import org.simantics.g2d.image.DefaultImages;
import org.simantics.g2d.image.Image;
import org.simantics.g2d.image.impl.ImageProxy;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.scenegraph.g2d.events.Event;
import org.simantics.scenegraph.g2d.events.EventTypes;
import org.simantics.scenegraph.g2d.events.IEventHandler;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scl.runtime.tuple.Tuple2;
import org.simantics.ui.dnd.LocalObjectTransfer;
import org.simantics.ui.dnd.LocalObjectTransferable;
import org.simantics.ui.dnd.MultiTransferable;
import org.simantics.ui.dnd.PlaintextTransfer;
import org.simantics.utils.datastructures.cache.ProvisionException;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.threads.AWTThread;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.SWTThread;
import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ExceptionUtils;

public class SymbolLibraryComposite
extends Composite {
    private static final int FILTER_DELAY = 500;
    private static final String KEY_VIEWER_INITIALIZED = "viewer.initialized";
    private static final String KEY_USER_EXPANDED = "userExpanded";
    private static final String KEY_GROUP_FILTERED = "groupFiltered";
    ScrolledComposite sc;
    Composite c;
    IThreadWorkQueue swtThread;
    boolean defaultExpanded = false;
    ISymbolProvider symbolProvider;
    AtomicBoolean disposed = new AtomicBoolean(false);
    AtomicInteger loadCount = new AtomicInteger();
    Map<ISymbolGroup, PGroup> groups = new HashMap<ISymbolGroup, PGroup>();
    Map<ISymbolGroup, GalleryViewer> groupViewers = new HashMap<ISymbolGroup, GalleryViewer>();
    Map<Object, Boolean> expandedGroups = new HashMap<Object, Boolean>();
    LocalResourceManager resourceManager;
    FilterArea filter;
    ThreadFactory threadFactory = new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "Symbol Library Loader");
            t.setDaemon(false);
            t.setPriority(5);
            return t;
        }
    };
    Semaphore loaderSemaphore = new Semaphore(1);
    ExecutorService loaderExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 2L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), this.threadFactory);
    Map<ISymbolItem, SoftReference<ImageProxy>> imageCache = new WeakHashMap<ISymbolItem, SoftReference<ImageProxy>>();
    static final Pattern ANY = Pattern.compile(".*");
    Pattern currentFilterPattern = ANY;
    FilterConfiguration config = new FilterConfiguration();
    IFilter currentGroupFilter = AcceptAllFilter.getInstance();
    ErrorHandler errorHandler = LogErrorHandler.INSTANCE;
    Comparator<GroupDescriptor> groupComparator = new Comparator<GroupDescriptor>(){

        @Override
        public int compare(GroupDescriptor o1, GroupDescriptor o2) {
            return o1.label.compareToIgnoreCase(o2.label);
        }
    };
    static final EnumSet<Image.Feature> VOLATILE = EnumSet.of(Image.Feature.Volatile);
    ExpandListener groupExpandListener = new ExpandListener(){

        public void itemCollapsed(ExpandEvent e) {
            PGroup group = (PGroup)e.widget;
            group.setData(SymbolLibraryComposite.KEY_USER_EXPANDED, (Object)Boolean.FALSE);
            SymbolLibraryComposite.this.storeGroupExpandedState(group, false);
            SymbolLibraryComposite.this.refreshScrolledComposite();
        }

        public void itemExpanded(ExpandEvent e) {
            PGroup group = (PGroup)e.widget;
            group.setData(SymbolLibraryComposite.KEY_USER_EXPANDED, (Object)Boolean.TRUE);
            SymbolLibraryComposite.this.storeGroupExpandedState(group, true);
            ThreadUtils.asyncExec((IThreadWorkQueue)SymbolLibraryComposite.this.swtThread, () -> {
                GalleryViewer viewer = SymbolLibraryComposite.this.initializeGroup(group);
                if (viewer == null) {
                    return;
                }
                ThreadUtils.asyncExec((IThreadWorkQueue)SymbolLibraryComposite.this.swtThread, () -> {
                    if (viewer.getControl().isDisposed()) {
                        return;
                    }
                    viewer.refresh();
                    SymbolLibraryComposite.this.refreshScrolledComposite();
                });
            });
        }
    };
    Runnable filterActivator = new Runnable(){

        @Override
        public void run() {
            SymbolLibraryComposite.this.filter.focus();
        }
    };
    Listener filterActivationListener = new Listener(){

        public void handleEvent(org.eclipse.swt.widgets.Event event) {
            SymbolLibraryComposite.this.filterActivator.run();
        }
    };
    ISymbolGroupListener groupListener = new ISymbolGroupListener(){

        @Override
        public void itemsChanged(ISymbolGroup group) {
            GalleryViewer viewer = SymbolLibraryComposite.this.groupViewers.get(group);
            if (viewer != null) {
                ISymbolItem[] input = group.getItems();
                viewer.setInput((Object)input);
            }
        }
    };
    IEventHandler externalEventHandler = new IEventHandler(){

        public int getEventMask() {
            IEventHandler handler = SymbolLibraryComposite.this.eventHandler;
            return handler != null ? handler.getEventMask() : 0;
        }

        public boolean handleEvent(Event e) {
            IEventHandler handler = SymbolLibraryComposite.this.eventHandler;
            return handler != null && EventTypes.passes((IEventHandler)handler, (Event)e) ? handler.handleEvent(e) : false;
        }
    };
    protected volatile IEventHandler eventHandler;

    public SymbolLibraryComposite(Composite parent, int style, SymbolProviderFactory symbolProvider) {
        super(parent, style);
        this.init(parent, style);
        Simantics.getSession().asyncRequest((Read)new CreateSymbolProvider(symbolProvider), (org.simantics.db.procedure.Listener)new SymbolProviderListener());
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SymbolLibraryComposite.this.disposed.set(true);
            }
        });
    }

    private static void print(ISymbolProvider provider) {
        for (ISymbolGroup grp : provider.getSymbolGroups()) {
            System.out.println("GROUP: " + grp);
            if (!(grp instanceof CompositeSymbolGroup)) continue;
            CompositeSymbolGroup cgrp = (CompositeSymbolGroup)grp;
            for (ISymbolGroup grp2 : cgrp.getGroups()) {
                System.out.println("\tGROUP: " + grp2);
            }
        }
    }

    private void init(Composite parent, int style) {
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo((Composite)this);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources((Display)this.getDisplay()), (Control)this);
        this.swtThread = SWTThread.getThreadAccess((Widget)this);
        this.filter = new FilterArea(this, 0);
        this.filter.getText().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                SymbolLibraryComposite.this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (SymbolLibraryComposite.this.isDisposed()) {
                            return;
                        }
                        Control c = SymbolLibraryComposite.this.getDisplay().getFocusControl();
                        while (c != null) {
                            if (c == SymbolLibraryComposite.this) {
                                (this).SymbolLibraryComposite.this.filter.getText().setFocus();
                                return;
                            }
                            c = c.getParent();
                        }
                    }
                });
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.filter);
        this.filter.getText().addModifyListener(new ModifyListener(){
            int modCount = 0;

            public void modifyText(ModifyEvent e) {
                this.scheduleDelayedFilter(500L, TimeUnit.MILLISECONDS);
            }

            private void scheduleDelayedFilter(long filterDelay, TimeUnit delayUnit) {
                final String text = SymbolLibraryComposite.this.filter.getText().getText();
                final int count = ++this.modCount;
                ThreadUtils.getNonBlockingWorkExecutor().schedule(new Runnable(){

                    @Override
                    public void run() {
                        int newCount = modCount;
                        if (newCount != count) {
                            return;
                        }
                        ThreadUtils.asyncExec((IThreadWorkQueue)(this).SymbolLibraryComposite.this.swtThread, (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (((this).this).SymbolLibraryComposite.this.sc.isDisposed()) {
                                    return;
                                }
                                if (!SymbolLibraryComposite.this.filterGroups(text)) {
                                    this.scheduleDelayedFilter(100L, TimeUnit.MILLISECONDS);
                                }
                            }
                        });
                    }
                }, filterDelay, delayUnit);
            }
        });
        this.sc = new ScrolledComposite((Composite)this, 512);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.sc);
        this.sc.setAlwaysShowScrollBars(false);
        this.sc.setExpandHorizontal(false);
        this.sc.setExpandVertical(false);
        this.sc.getVerticalBar().setIncrement(30);
        this.sc.getVerticalBar().setPageIncrement(200);
        this.sc.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                SymbolLibraryComposite.this.refreshScrolledComposite();
            }
        });
        this.c = new Composite((Composite)this.sc, 0);
        this.c.setVisible(false);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(this.c);
        this.sc.setContent((Control)this.c);
        SWTMouseEventAdapter noContextEventAdapter = new SWTMouseEventAdapter(null, this.externalEventHandler);
        this.installMouseEventAdapter((Control)this.sc, noContextEventAdapter);
        this.installMouseEventAdapter((Control)this.c, noContextEventAdapter);
        this.c.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SymbolLibraryComposite.this.loaderExecutor.shutdown();
                SymbolLibraryComposite.this.groupViewers.clear();
            }
        });
    }

    void refreshScrolledComposite() {
        ThreadUtils.asyncExec((IThreadWorkQueue)this.swtThread, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (SymbolLibraryComposite.this.sc.isDisposed()) {
                    return;
                }
                SymbolLibraryComposite.this.syncRefreshScrolledComposite();
            }
        });
    }

    void syncRefreshScrolledComposite() {
        Rectangle r = this.sc.getClientArea();
        Point contentSize = this.c.computeSize(r.width, -1);
        this.c.setSize(contentSize);
    }

    void load(Collection<ISymbolGroup> _libraries) {
        if (_libraries == null) {
            _libraries = Collections.emptyList();
        }
        final Collection<ISymbolGroup> libraries = _libraries;
        if (this.loaderExecutor.isShutdown()) {
            return;
        }
        this.loaderExecutor.execute(new Runnable(){

            @Override
            public void run() {
                Integer loadId = SymbolLibraryComposite.this.loadCount.incrementAndGet();
                try {
                    SymbolLibraryComposite.this.loaderSemaphore.acquire();
                    this.beginPopulate(loadId);
                }
                catch (InterruptedException e) {
                    ExceptionUtils.logError((Throwable)e);
                }
                catch (RuntimeException e) {
                    SymbolLibraryComposite.this.loaderSemaphore.release();
                    ExceptionUtils.logAndShowError((Throwable)e);
                }
                catch (Error e) {
                    SymbolLibraryComposite.this.loaderSemaphore.release();
                    ExceptionUtils.logAndShowError((Throwable)e);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void beginPopulate(Integer loadId) {
                Map<ISymbolGroup, PGroup> map = SymbolLibraryComposite.this.groups;
                synchronized (map) {
                    Iterator<Map.Entry<ISymbolGroup, PGroup>> it = SymbolLibraryComposite.this.groups.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry<ISymbolGroup, PGroup> entry = it.next();
                        if (libraries.contains(entry.getKey())) continue;
                        PGroup group = entry.getValue();
                        it.remove();
                        SymbolLibraryComposite.this.groupViewers.remove(entry.getKey());
                        if (group == null || group.isDisposed()) continue;
                        ThreadUtils.asyncExec((IThreadWorkQueue)SymbolLibraryComposite.this.swtThread, (Runnable)SymbolLibraryComposite.this.disposer((Widget)group));
                    }
                    TreeSet<GroupDescriptor> groupDescs = new TreeSet<GroupDescriptor>(SymbolLibraryComposite.this.groupComparator);
                    for (ISymbolGroup lib : libraries) {
                        PGroup group = SymbolLibraryComposite.this.groups.get(lib);
                        String label = lib.getName();
                        String description = lib.getDescription();
                        groupDescs.add(new GroupDescriptor(lib, label, description, group));
                    }
                    IFilter groupFilter = SymbolLibraryComposite.this.currentGroupFilter;
                    SymbolLibraryComposite.this.populateGroups(SymbolLibraryComposite.this.loaderExecutor, null, groupDescs.iterator(), groupFilter, loadId, new Runnable(){

                        @Override
                        public void run() {
                            (this).SymbolLibraryComposite.this.loaderSemaphore.release();
                        }
                    });
                }
            }
        });
    }

    void populateGroups(final ExecutorService exec, final Control lastGroup, final Iterator<GroupDescriptor> iter, final IFilter groupFilter, final Integer loadId, final Runnable loadComplete) {
        int currentLoadId = this.loadCount.get();
        if (currentLoadId != loadId) {
            loadComplete.run();
            return;
        }
        if (!iter.hasNext()) {
            ThreadUtils.asyncExec((IThreadWorkQueue)this.swtThread, (Runnable)new Runnable(){

                @Override
                public void run() {
                    if (SymbolLibraryComposite.this.filter.isDisposed() || SymbolLibraryComposite.this.c.isDisposed()) {
                        return;
                    }
                    SymbolLibraryComposite.this.c.setVisible(true);
                }
            });
            loadComplete.run();
            return;
        }
        final GroupDescriptor desc = iter.next();
        ThreadUtils.asyncExec((IThreadWorkQueue)this.swtThread, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    this.populateGroup();
                }
                catch (RuntimeException e) {
                    loadComplete.run();
                    ExceptionUtils.logAndShowError((Throwable)e);
                }
                catch (Error e) {
                    loadComplete.run();
                    ExceptionUtils.logAndShowError((Throwable)e);
                }
            }

            public void populateGroup() {
                if (SymbolLibraryComposite.this.c.isDisposed()) {
                    loadComplete.run();
                    return;
                }
                PGroup group = desc.group;
                Runnable chainedCompletionCallback = loadComplete;
                if (group == null || group.isDisposed()) {
                    group = new PGroup(SymbolLibraryComposite.this.c, 0);
                    if (lastGroup != null) {
                        group.moveBelow(lastGroup);
                    } else {
                        group.moveAbove(null);
                    }
                    SymbolLibraryComposite.this.installMouseEventAdapter((Control)group, new SWTMouseEventAdapter((Object)group, SymbolLibraryComposite.this.externalEventHandler));
                    SymbolLibraryComposite.this.groups.put(desc.lib, group);
                    Boolean shouldBeExpanded = SymbolLibraryComposite.this.expandedGroups.get(SymbolLibraryComposite.symbolGroupToKey(desc.lib));
                    if (shouldBeExpanded == null) {
                        shouldBeExpanded = SymbolLibraryComposite.this.defaultExpanded;
                    }
                    group.setData(SymbolLibraryComposite.KEY_USER_EXPANDED, (Object)shouldBeExpanded);
                    group.setExpanded(shouldBeExpanded.booleanValue());
                    group.setFont(SymbolLibraryComposite.this.resourceManager.createFont(FontDescriptor.createFrom((Font)group.getFont()).setStyle(0).increaseHeight(-1)));
                    GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)group);
                    GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo((Composite)group);
                    group.addExpandListener(SymbolLibraryComposite.this.groupExpandListener);
                    if (desc.lib instanceof IModifiableSymbolGroup) {
                        IModifiableSymbolGroup mod = (IModifiableSymbolGroup)desc.lib;
                        mod.addListener(SymbolLibraryComposite.this.groupListener);
                    }
                    if (shouldBeExpanded.booleanValue()) {
                        PGroup expandedGroup = group;
                        chainedCompletionCallback = () -> {
                            ThreadUtils.asyncExec((IThreadWorkQueue)SymbolLibraryComposite.this.swtThread, () -> {
                                boolean bl = SymbolLibraryComposite.this.setExpandedState(expandedGroup, true, true);
                            });
                            loadComplete.run();
                        };
                    }
                }
                group.setData("group", (Object)desc.lib);
                group.setText(desc.label);
                group.setToolTipText(desc.description);
                boolean groupFiltered = !groupFilter.select((Object)desc.label);
                group.setData(SymbolLibraryComposite.KEY_GROUP_FILTERED, (Object)groupFiltered);
                if (groupFiltered) {
                    SymbolLibraryComposite.this.setGroupVisible(group, false);
                }
                SymbolLibraryComposite.this.syncRefreshScrolledComposite();
                PGroup group_ = group;
                Runnable newCompletionCallback = chainedCompletionCallback;
                exec.execute(() -> SymbolLibraryComposite.this.populateGroups(exec, (Control)group_, iter, groupFilter, loadId, newCompletionCallback));
            }
        });
    }

    protected void installMouseEventAdapter(Control onControl, SWTMouseEventAdapter eventAdapter) {
        onControl.addMouseListener((MouseListener)eventAdapter);
        onControl.addMouseTrackListener((MouseTrackListener)eventAdapter);
        onControl.addMouseMoveListener((MouseMoveListener)eventAdapter);
        onControl.addMouseWheelListener((MouseWheelListener)eventAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GalleryViewer initializeGroup(PGroup group) {
        if (group.isDisposed()) {
            return null;
        }
        PGroup pGroup = group;
        synchronized (pGroup) {
            if (group.getData(KEY_VIEWER_INITIALIZED) != null) {
                return (GalleryViewer)group.getData("gallery");
            }
            group.setData(KEY_VIEWER_INITIALIZED, (Object)Boolean.TRUE);
        }
        GalleryViewer viewer = new GalleryViewer((Composite)group);
        ISymbolGroup input = (ISymbolGroup)group.getData("group");
        this.initializeViewer(group, input, viewer);
        this.groupViewers.put(input, viewer);
        group.setData("gallery", (Object)viewer);
        return viewer;
    }

    void initializeViewer(final PGroup group, ISymbolGroup input, final GalleryViewer viewer) {
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo(viewer.getControl());
        viewer.addDragSupport((IDragSourceParticipant)new DragSourceParticipant());
        viewer.setAlign(FlowLayout.Align.Left);
        viewer.getDiagram().setHint(SynchronizationHints.ERROR_HANDLER, (Object)this.errorHandler);
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement == null) {
                    return new Object[0];
                }
                return ((ISymbolGroup)inputElement).getItems();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        viewer.setInput((Object)input);
        viewer.getCanvasContext().getEventHandlerStack().add((Object)new IEventHandler(){

            public int getEventMask() {
                return SymbolLibraryComposite.this.externalEventHandler.getEventMask() | EventTypes.MouseDoubleClickMask;
            }

            public boolean handleEvent(Event e) {
                if (SymbolLibraryComposite.this.externalEventHandler.handleEvent(e)) {
                    return true;
                }
                if (e instanceof MouseEvent.MouseDoubleClickedEvent) {
                    PickRequest req = new PickRequest(((MouseEvent.MouseDoubleClickedEvent)e).controlPosition);
                    ArrayList result = new ArrayList();
                    DiagramUtils.pick((IDiagram)viewer.getDiagram(), (PickRequest)req, result);
                    if (!result.isEmpty()) {
                        return false;
                    }
                    if (group.isDisposed()) {
                        return false;
                    }
                    group.getDisplay().asyncExec(() -> {
                        if (group.isDisposed()) {
                            return;
                        }
                        boolean exp = !group.getExpanded();
                        group.setData(SymbolLibraryComposite.KEY_USER_EXPANDED, (Object)exp);
                        SymbolLibraryComposite.this.setGroupExpandedWithoutNotification(group, exp);
                        SymbolLibraryComposite.this.refreshScrolledComposite();
                    });
                    return true;
                }
                return false;
            }
        }, 0);
    }

    static String toPatternString(String filter) {
        return DefaultFilterStrategy.defaultToPatternString(filter, true);
    }

    static Pattern toPattern(String filterText) {
        String regExFilter = SymbolLibraryComposite.toPatternString(filterText);
        Pattern pattern = regExFilter != null ? Pattern.compile(regExFilter) : ANY;
        return pattern;
    }

    static IFilter composeFilter(FilterConfiguration config) {
        final FilterConfiguration.Mode mode = config.getMode();
        final ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (GroupFilter f : config.getFilters()) {
            if (!f.isActive()) continue;
            patterns.add(SymbolLibraryComposite.toPattern(f.getFilterText()));
        }
        return new IFilter(){

            public boolean select(Object toTest) {
                if (patterns.isEmpty()) {
                    return true;
                }
                String s = (String)toTest;
                switch (mode) {
                    case AND: {
                        for (Pattern pat : patterns) {
                            Matcher m = pat.matcher(s.toLowerCase());
                            if (m.matches()) continue;
                            return false;
                        }
                        return true;
                    }
                    case OR: {
                        for (Pattern pat : patterns) {
                            Matcher m = pat.matcher(s.toLowerCase());
                            if (!m.matches()) continue;
                            return true;
                        }
                        return false;
                    }
                }
                throw new Error("Shouldn't happen");
            }
        };
    }

    void updateFilterConfiguration(FilterConfiguration config) {
        IFilter filter;
        this.config = config;
        this.currentGroupFilter = filter = SymbolLibraryComposite.composeFilter(config);
    }

    void applyGroupFilters() {
        Control[] grps;
        IFilter groupFilter = this.currentGroupFilter;
        final boolean[] changed = new boolean[1];
        Control[] controlArray = grps = this.c.getChildren();
        int n = grps.length;
        int n2 = 0;
        while (n2 < n) {
            Control ctrl = controlArray[n2];
            PGroup grp = (PGroup)ctrl;
            boolean visible = grp.getVisible();
            boolean shouldBeVisible = groupFilter.select((Object)grp.getText());
            boolean change = visible ^ shouldBeVisible;
            changed[0] = changed[0] | change;
            grp.setData(KEY_GROUP_FILTERED, (Object)(!shouldBeVisible ? 1 : 0));
            if (change) {
                this.setGroupVisible(grp, shouldBeVisible);
            }
            ++n2;
        }
        ThreadUtils.asyncExec((IThreadWorkQueue)this.swtThread, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (SymbolLibraryComposite.this.c.isDisposed()) {
                    return;
                }
                if (changed[0]) {
                    SymbolLibraryComposite.this.c.layout(true);
                    SymbolLibraryComposite.this.syncRefreshScrolledComposite();
                }
            }
        });
    }

    boolean filterGroups(String text) {
        Control[] grps;
        Pattern pattern;
        String regExFilter = SymbolLibraryComposite.toPatternString(text);
        this.currentFilterPattern = pattern = regExFilter != null ? Pattern.compile(regExFilter) : ANY;
        final boolean[] changed = new boolean[1];
        boolean filteringComplete = true;
        SymbolItemFilter filter = null;
        if (regExFilter != null) {
            filter = new SymbolItemFilter(regExFilter, pattern);
        }
        Control[] controlArray = grps = this.c.getChildren();
        int n = grps.length;
        int n2 = 0;
        while (n2 < n) {
            Control ctrl = controlArray[n2];
            PGroup grp = (PGroup)ctrl;
            if (!grp.isDisposed()) {
                Boolean contentsChanged = this.filterGroup(grp, filter);
                if (contentsChanged == null) {
                    filteringComplete = false;
                } else {
                    changed[0] = contentsChanged;
                }
            }
            ++n2;
        }
        ThreadUtils.asyncExec((IThreadWorkQueue)this.swtThread, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (SymbolLibraryComposite.this.c.isDisposed()) {
                    return;
                }
                if (changed[0]) {
                    SymbolLibraryComposite.this.c.layout(true);
                    SymbolLibraryComposite.this.syncRefreshScrolledComposite();
                }
            }
        });
        return filteringComplete;
    }

    static boolean objectEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    private Boolean filterGroup(PGroup grp, ViewerFilter filter) {
        boolean shouldBeExpanded;
        boolean changed = false;
        GalleryViewer viewer = this.initializeGroup(grp);
        if (viewer == null) {
            return null;
        }
        ViewerFilter lastFilter = viewer.getFilter();
        boolean groupFiltered = Boolean.TRUE.equals(grp.getData(KEY_GROUP_FILTERED));
        boolean userExpanded = Boolean.TRUE.equals(grp.getData(KEY_USER_EXPANDED));
        boolean expanded = grp.getExpanded();
        boolean visible = grp.getVisible();
        boolean filterChanged = !SymbolLibraryComposite.objectEquals(filter, lastFilter);
        ISymbolGroup symbolGroup = (ISymbolGroup)grp.getData("group");
        boolean filterMatchesGroup = filter != null && filter.select((Viewer)viewer, null, (Object)symbolGroup);
        viewer.setFilter(filterMatchesGroup ? null : filter);
        Object[] elements = viewer.getFilteredElements();
        boolean shouldBeVisible = !groupFiltered && (elements.length > 0 || filterMatchesGroup);
        boolean bl = shouldBeExpanded = shouldBeVisible && (filter != null || userExpanded);
        if (filterChanged || visible != shouldBeVisible || expanded != shouldBeExpanded) {
            changed = true;
            if (shouldBeVisible == userExpanded) {
                if (expanded != shouldBeExpanded) {
                    this.setGroupExpandedWithoutNotification(grp, shouldBeExpanded);
                }
                this.setGroupVisible(grp, shouldBeVisible);
            } else if (filter != null) {
                if (shouldBeVisible) {
                    this.setGroupExpandedWithoutNotification(grp, true);
                    this.setGroupVisible(grp, true);
                } else {
                    this.setGroupExpandedWithoutNotification(grp, true);
                    this.setGroupVisible(grp, false);
                }
            } else {
                if (expanded != userExpanded) {
                    this.setGroupExpandedWithoutNotification(grp, userExpanded);
                }
                if (!visible) {
                    this.setGroupVisible(grp, true);
                }
            }
            if (shouldBeExpanded) {
                viewer.refreshWithContent(elements);
            }
        }
        return changed;
    }

    void setGroupExpandedWithoutNotification(PGroup grp, boolean expanded) {
        this.storeGroupExpandedState(grp, expanded);
        grp.setExpanded(expanded);
    }

    void setGroupVisible(PGroup group, boolean visible) {
        GridData gd = (GridData)group.getLayoutData();
        gd.exclude = !visible;
        group.setVisible(visible);
    }

    boolean isGroupFiltered(String label) {
        return !this.currentFilterPattern.matcher(label.toLowerCase()).matches();
    }

    public boolean isDefaultExpanded() {
        return this.defaultExpanded;
    }

    public void setDefaultExpanded(boolean defaultExpanded) {
        this.defaultExpanded = defaultExpanded;
    }

    Runnable disposer(final Widget w) {
        return new Runnable(){

            @Override
            public void run() {
                if (w.isDisposed()) {
                    return;
                }
                w.dispose();
            }
        };
    }

    public void setAllExpandedStates(boolean targetState) {
        this.setDefaultExpanded(targetState);
        Control[] grps = this.c.getChildren();
        boolean changed = false;
        Control[] controlArray = grps;
        int n = grps.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            changed |= this.setExpandedState((PGroup)control, targetState, false);
            ++n2;
        }
        if (changed) {
            this.refreshScrolledComposite();
        }
    }

    boolean setExpandedState(PGroup grp, boolean targetState, boolean force) {
        if (grp.isDisposed()) {
            return false;
        }
        this.storeGroupExpandedState(grp, targetState);
        grp.setData(KEY_USER_EXPANDED, (Object)targetState);
        if ((force || grp.getExpanded() != targetState) && grp.getVisible()) {
            GalleryViewer viewer = this.initializeGroup(grp);
            this.setGroupExpandedWithoutNotification(grp, targetState);
            ThreadUtils.asyncExec((IThreadWorkQueue)this.swtThread, () -> {
                if (!grp.isDisposed()) {
                    if (viewer != null) {
                        viewer.refresh();
                    }
                    this.refreshScrolledComposite();
                }
            });
            return true;
        }
        return false;
    }

    public FilterArea getFilterArea() {
        return this.filter;
    }

    public static void scheduleSymbolUpdate(final AtomicBoolean disposed, final ImageProxy imageProxy, final ElementClass ec) {
        if (disposed.get()) {
            return;
        }
        ThreadUtils.asyncExec((IThreadWorkQueue)AWTThread.getThreadAccess(), (Runnable)new Runnable(){

            @Override
            public void run() {
                if (disposed.get()) {
                    return;
                }
                SymbolLibraryComposite.symbolUpdate(disposed, imageProxy, ec);
            }
        });
    }

    public static void symbolUpdate(AtomicBoolean disposed, ImageProxy imageProxy, ElementClass ec) {
        StaticSymbol ss = (StaticSymbol)ec.getSingleItem(StaticSymbol.class);
        Image source = ss == null ? (Image)DefaultImages.UNKNOWN2.get() : ss.getImage();
        imageProxy.setSource(source);
    }

    public void setEventHandler(IEventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    protected void storeGroupExpandedState(PGroup group, boolean expanded) {
        ISymbolGroup symbolGroup = (ISymbolGroup)group.getData("group");
        if (symbolGroup != null) {
            Object key = SymbolLibraryComposite.symbolGroupToKey(symbolGroup);
            this.expandedGroups.put(key, expanded ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    private static Object symbolGroupToKey(ISymbolGroup symbolGroup) {
        if (symbolGroup instanceof IIdentifiedObject) {
            return ((IIdentifiedObject)((Object)symbolGroup)).getId();
        }
        return new Tuple2((Object)symbolGroup.getName(), (Object)symbolGroup.getDescription());
    }

    static class CreateSymbolProvider
    extends UnaryRead<SymbolProviderFactory, ISymbolProvider> {
        public CreateSymbolProvider(SymbolProviderFactory factory) {
            super((Object)factory);
        }

        public ISymbolProvider perform(ReadGraph graph) throws DatabaseException {
            ISymbolProvider provider = ((SymbolProviderFactory)this.parameter).create(graph);
            return provider;
        }
    }

    class DragSourceParticipant
    extends AbstractDiagramParticipant
    implements IDragSourceParticipant {
        @DependencyReflection.Reference
        Selection selection;
        @DependencyReflection.Dependency
        PointerInteractor pi;
        @DependencyReflection.Dependency
        TransformUtil util;
        @DependencyReflection.Dependency
        PickContext pickContext;

        DragSourceParticipant() {
        }

        public int canDrag(MouseEvent.MouseDragBegin me) {
            if (me.button != 1) {
                return 0;
            }
            if (this.getHint(Hints.KEY_TOOL) != Hints.POINTERTOOL) {
                return 0;
            }
            this.assertDependencies();
            PickRequest req = new PickRequest(me.startCanvasPos);
            req.pickPolicy = PickRequest.PickPolicy.PICK_INTERSECTING_OBJECTS;
            ArrayList picks = new ArrayList();
            this.pickContext.pick(this.diagram, req, picks);
            Set sel = this.selection.getSelection(me.mouseId);
            if (Collections.disjoint(sel, picks)) {
                return 0;
            }
            return 1;
        }

        public Transferable dragStart(DragGestureEvent e) {
            AWTChassis chassis = (AWTChassis)e.getComponent();
            ICanvasContext cc = chassis.getCanvasContext();
            Selection sel = (Selection)cc.getSingleItem(Selection.class);
            Set ss = sel.getSelection(0);
            if (ss.isEmpty()) {
                return null;
            }
            Object[] res = new Object[ss.size()];
            int index = 0;
            for (IElement ee : ss) {
                res[index++] = ee.getHint(ElementHints.KEY_OBJECT);
            }
            StructuredSelection object = new StructuredSelection(res);
            LocalObjectTransferable local = new LocalObjectTransferable((Object)object);
            StringBuilder json = new StringBuilder();
            json.append("{");
            json.append(" \"type\" : \"Symbol\",");
            json.append(" \"res\" : [");
            int pos = 0;
            int i = 0;
            while (i < res.length) {
                Resource resource;
                Object r;
                if (pos > 0) {
                    json.append(",");
                }
                if ((r = res[i]) instanceof IAdaptable && (resource = (Resource)((IAdaptable)r).getAdapter(Resource.class)) != null) {
                    long rid = resource.getResourceId();
                    json.append(Long.toString(rid));
                    ++pos;
                }
                ++i;
            }
            json.append("] }");
            String jsonText = json.toString();
            StringSelection text = new StringSelection(jsonText);
            PlaintextTransfer plainText = new PlaintextTransfer(jsonText);
            return new MultiTransferable(new Transferable[]{local, text, plainText});
        }

        public int getAllowedOps() {
            return 1;
        }

        public void dragDropEnd(DragSourceDropEvent dsde) {
            LocalObjectTransfer.getTransfer().clear();
        }

        public void dragEnter(DragSourceDragEvent dsde) {
        }

        public void dragExit(DragSourceEvent dse) {
        }

        public void dragOver(DragSourceDragEvent dsde) {
        }

        public void dropActionChanged(DragSourceDragEvent dsde) {
        }
    }

    static class ElementClassListener
    implements org.simantics.db.procedure.Listener<ElementClass> {
        private Map<ISymbolItem, SoftReference<ImageProxy>> imageCache;
        private final AtomicBoolean disposed;
        private final ISymbolItem item;

        public ElementClassListener(Map<ISymbolItem, SoftReference<ImageProxy>> imageCache, AtomicBoolean disposed, ISymbolItem item) {
            this.imageCache = imageCache;
            this.disposed = disposed;
            this.item = item;
        }

        public void execute(ElementClass ec) {
            ImageProxy[] imageProxy = new ImageProxy[1];
            SoftReference<ImageProxy> proxyRef = this.imageCache.get(this.item);
            if (proxyRef != null) {
                imageProxy[0] = proxyRef.get();
            }
            if (imageProxy[0] != null) {
                SymbolLibraryComposite.scheduleSymbolUpdate(this.disposed, imageProxy[0], ec);
            }
        }

        public void exception(Throwable t) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.diagram", "Error in ElementClass request.", t));
        }

        public boolean isDisposed() {
            return this.disposed.get();
        }
    }

    static class GroupDescriptor {
        public final ISymbolGroup lib;
        public final String label;
        public final String description;
        public final PGroup group;

        public GroupDescriptor(ISymbolGroup lib, String label, String description, PGroup group) {
            assert (lib != null);
            assert (label != null);
            this.lib = lib;
            this.label = label;
            this.description = description;
            this.group = group;
        }
    }

    class ImageLoader
    implements Runnable {
        private final ImageProxy imageProxy;
        private final ISymbolItem item;

        public ImageLoader(ImageProxy imageProxy, ISymbolItem item) {
            this.imageProxy = imageProxy;
            this.item = item;
        }

        @Override
        public void run() {
            ThreadUtils.asyncExec((IThreadWorkQueue)AWTThread.getThreadAccess(), () -> this.runBlocking());
        }

        private void runBlocking() {
            try {
                ISymbolGroup group = this.item.getGroup();
                if (group == null) {
                    throw new ProvisionException("No ISymbolGroup available for ISymbolItem " + this.item);
                }
                GalleryViewer viewer = SymbolLibraryComposite.this.groupViewers.get(group);
                if (viewer == null) {
                    this.imageProxy.setSource((Image)DefaultImages.UNKNOWN2.get());
                    return;
                }
                IDiagram hints = viewer.getDiagram();
                if (hints == null) {
                    throw new ProvisionException("No diagram available for GalleryViewer of group " + group);
                }
                hints.setHint(ISymbolItem.KEY_ELEMENT_CLASS_LISTENER, (Object)new ElementClassListener(SymbolLibraryComposite.this.imageCache, SymbolLibraryComposite.this.disposed, this.item));
                ElementClass ec = this.item.getElementClass((IHintObservable)hints);
                SymbolLibraryComposite.symbolUpdate(SymbolLibraryComposite.this.disposed, this.imageProxy, ec);
            }
            catch (ProvisionException e) {
                ExceptionUtils.logWarning((String)("Failed to provide element class for symbol item " + this.item), (Throwable)e);
                this.imageProxy.setSource((Image)DefaultImages.ERROR_DECORATOR.get());
            }
            catch (Exception e) {
                ExceptionUtils.logError((Throwable)e);
                this.imageProxy.setSource((Image)DefaultImages.ERROR_DECORATOR.get());
            }
        }
    }

    class LabelProvider
    extends BaseLabelProvider
    implements ILabelProvider {
        LabelProvider() {
        }

        public Image getImage(Object element) {
            ISymbolItem item = (ISymbolItem)element;
            ImageProxy proxy = null;
            SoftReference<ImageProxy> proxyRef = SymbolLibraryComposite.this.imageCache.get(item);
            if (proxyRef != null) {
                proxy = proxyRef.get();
            }
            if (proxy == null) {
                proxy = new PendingImage((Image)DefaultImages.HOURGLASS.get(), VOLATILE);
                SymbolLibraryComposite.this.imageCache.put(item, new SoftReference<ImageProxy>(proxy));
                ThreadUtils.getNonBlockingWorkExecutor().schedule(new ImageLoader(proxy, item), 100L, TimeUnit.MILLISECONDS);
            }
            return proxy;
        }

        public String getText(Object element) {
            return ((ISymbolItem)element).getName();
        }

        public String getToolTipText(Object element) {
            String desc;
            ISymbolItem item = (ISymbolItem)element;
            String name = item.getName();
            return name.equals(desc = item.getDescription()) ? name : String.valueOf(name) + " - " + desc;
        }

        public java.awt.Image getToolTipImage(Object object) {
            return null;
        }

        public Color getToolTipBackgroundColor(Object object) {
            return null;
        }

        public Color getToolTipForegroundColor(Object object) {
            return null;
        }
    }

    static class PendingImage
    extends ImageProxy {
        EnumSet<Image.Feature> features;

        PendingImage(Image source, EnumSet<Image.Feature> features) {
            super(source);
            this.features = features;
        }

        public EnumSet<Image.Feature> getFeatures() {
            return this.features;
        }
    }

    static class SymbolItemFilter
    extends ViewerFilter {
        private final String string;
        private final Matcher m;

        public SymbolItemFilter(String string, Pattern pattern) {
            this.string = string;
            this.m = pattern.matcher("");
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof ISymbolItem) {
                ISymbolItem item = (ISymbolItem)element;
                return this.matchesFilter(item.getName()) || this.matchesFilter(item.getDescription());
            }
            if (element instanceof ISymbolGroup) {
                ISymbolGroup group = (ISymbolGroup)element;
                return this.matchesFilter(group.getName());
            }
            return false;
        }

        private boolean matchesFilter(String str) {
            this.m.reset(str.toLowerCase());
            boolean matches = this.m.matches();
            return matches;
        }

        public int hashCode() {
            return this.string == null ? 0 : this.string.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            SymbolItemFilter other = (SymbolItemFilter)((Object)obj);
            return !(this.string == null ? other.string != null : !this.string.equals(other.string));
        }
    }

    class SymbolProviderListener
    extends ListenerAdapter<ISymbolProvider> {
        SymbolProviderListener() {
        }

        public void exception(Throwable t) {
            ErrorLogger.defaultLogError((Throwable)t);
        }

        public void execute(ISymbolProvider result) {
            SymbolLibraryComposite.this.symbolProvider = result;
            if (result != null) {
                Collection<ISymbolGroup> groups = result.getSymbolGroups();
                SymbolLibraryComposite.this.load(groups);
            }
        }

        public boolean isDisposed() {
            boolean result = SymbolLibraryComposite.this.isDisposed();
            return result;
        }
    }
}

