/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.flag;

import java.util.Collection;
import java.util.Collections;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.flag.IFlagType;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.g2d.elementclass.FlagClass;
import org.simantics.layer0.utils.binaryPredicates.OrderedSetElementsPredicate;
import org.simantics.structural2.modelingRules.IModelingRules;

public abstract class AbstractFlagType
implements IFlagType {
    protected final Resource flag;
    protected final IModelingRules modelingRules;

    public AbstractFlagType(Resource flag, IModelingRules modelingRules) {
        if (flag == null) {
            throw new NullPointerException("null flag");
        }
        if (modelingRules == null) {
            throw new NullPointerException("null modeling rules");
        }
        this.flag = flag;
        this.modelingRules = modelingRules;
    }

    protected FlagClass.Type getType(ReadGraph graph) throws DatabaseException {
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
        FlagClass.Type t = DiagramGraphUtil.toFlagType(dr, graph.getPossibleObject(this.flag, dr.HasFlagType));
        return t;
    }

    protected FlagClass.Mode getMode(ReadGraph graph) throws DatabaseException {
        return AbstractFlagType.getMode(graph, this.flag);
    }

    public static FlagClass.Mode getMode(ReadGraph graph, Resource flag) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Collection connectionJoins = graph.getObjects(flag, DIA.FlagIsJoinedBy);
        int joinCount = connectionJoins.size();
        if (joinCount == 0) {
            return FlagClass.internal((int)0);
        }
        Collection flagDiagram = OrderedSetElementsPredicate.INSTANCE.getSubjects(graph, flag);
        for (Resource connectionJoin : connectionJoins) {
            for (Resource otherFlag : graph.getObjects(connectionJoin, DIA.JoinsFlag)) {
                if (flag.equals(otherFlag) || !Collections.disjoint(flagDiagram, OrderedSetElementsPredicate.INSTANCE.getSubjects(graph, otherFlag))) continue;
                return FlagClass.external((int)joinCount);
            }
        }
        return FlagClass.internal((int)joinCount);
    }
}

