/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.adapter;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.g2d.element.handler.InternalSize;
import org.simantics.g2d.element.handler.Outline;
import org.simantics.g2d.element.handler.Pick;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.element.handler.Transform;
import org.simantics.g2d.utils.GeometryUtils;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.nodes.IPathListener;
import org.simantics.scenegraph.g2d.nodes.PathNode;
import org.simantics.scenegraph.g2d.nodes.PathNodeStyle;
import org.simantics.utils.datastructures.hints.IHintContext;

public class PathElementHandler
implements SceneGraph,
InternalSize,
Pick,
Outline {
    private static final long serialVersionUID = 2328124349273536527L;
    public static final IHintContext.Key SG_NODE = new SceneGraphNodeKey(Node.class, "SG_NODE");
    public static final IHintContext.Key KEY_PATH_LISTENER = new IHintContext.KeyOf(IPathListener.class, "PATH_LISTENER");
    public static final IHintContext.Key KEY_PATH_POINTS = new IHintContext.KeyOf(ArrayList.class, "PATH_POINTS");
    public static final IHintContext.Key KEY_PATH_CLOSED = new IHintContext.KeyOf(Boolean.class, "PATH_CLOSED");
    public static final IHintContext.Key KEY_PATH_STYLE = new IHintContext.KeyOf(PathNodeStyle.class, "PATH_STYLE");

    public void cleanup(IElement e) {
        Node node = (Node)e.removeHint(SG_NODE);
        if (node != null) {
            node.remove();
        }
    }

    public void init(IElement e, G2DParentNode parent) {
        PathNode node = (PathNode)e.getHint(SG_NODE);
        if (node == null) {
            node = (PathNode)parent.addNode(PathNode.class);
            e.setHint(SG_NODE, (Object)node);
        }
        ArrayList points = (ArrayList)e.getHint(KEY_PATH_POINTS);
        Boolean closed = (Boolean)e.getHint(KEY_PATH_CLOSED);
        if (points == null) {
            points = new ArrayList();
        }
        if (closed == null) {
            closed = false;
        }
        node.init(points, closed.booleanValue());
        PathNodeStyle style = (PathNodeStyle)e.getHint(KEY_PATH_STYLE);
        node.setStyle(style);
        IPathListener pathListener = (IPathListener)e.getHint(KEY_PATH_LISTENER);
        node.setPathListener(pathListener);
        AffineTransform at = ElementUtils.getTransform((IElement)e);
        node.setTransform(at);
    }

    public Rectangle2D getBounds(IElement e, Rectangle2D size) {
        PathNode node = (PathNode)e.getHint(SG_NODE);
        if (size == null) {
            size = new Rectangle2D.Double();
        }
        if (node != null) {
            size.setFrame(node.getBoundsInLocal());
        }
        return size;
    }

    public boolean pickTest(IElement e, Shape s, PickRequest.PickPolicy policy) {
        PathNode node = (PathNode)e.getHint(SG_NODE);
        if (node != null) {
            Transform t = (Transform)e.getElementClass().getSingleItem(Transform.class);
            AffineTransform canvasToElement = t.getTransform(e);
            switch (policy) {
                case PICK_CONTAINED_OBJECTS: {
                    return s.getBounds2D().contains(GeometryUtils.transformShape((Shape)node.getShape(), (AffineTransform)canvasToElement).getBounds2D());
                }
                case PICK_INTERSECTING_OBJECTS: {
                    if (node.isClosed()) {
                        return GeometryUtils.transformShape((Shape)node.getShape(), (AffineTransform)canvasToElement).intersects(s.getBounds());
                    }
                    return node.intersectsOutline(canvasToElement, s.getBounds2D());
                }
            }
        }
        return false;
    }

    public Shape getElementShape(IElement e) {
        PathNode node = (PathNode)e.getHint(SG_NODE);
        if (node != null) {
            return node.getShape();
        }
        return null;
    }
}

