/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.adapter;

import java.awt.geom.AffineTransform;
import java.util.Map;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.AsyncProcedureAdapter;
import org.simantics.db.common.procedure.adapter.ProcedureAdapter;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.request.Read;
import org.simantics.diagram.adapter.ElementParameterRequest;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.ErrorHandler;
import org.simantics.diagram.synchronization.ISynchronizationContext;
import org.simantics.diagram.synchronization.SynchronizationHints;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.diagram.synchronization.graph.GraphSynchronizationHints;
import org.simantics.diagram.synchronization.graph.layer.GraphLayerManager;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.layers.ILayers;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementFactoryUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElementFactoryUtil.class);

    public static void readTransform(AsyncReadGraph graph, final Resource resource, final IElement e) {
        ElementFactoryUtil.readTransform(graph, resource, e, (AsyncProcedure<IElement>)new AsyncProcedureAdapter<IElement>(){

            public void exception(AsyncReadGraph graph, Throwable t) {
                LOGGER.error("Error reading transform from " + resource + " into element " + e, t);
            }
        });
    }

    public static void readTransform(AsyncReadGraph graph, Resource resource, IElement e, AsyncProcedure<IElement> procedure) {
        DiagramResource DIA = (DiagramResource)graph.getService(DiagramResource.class);
        try {
            AffineTransform tr = DiagramGraphUtil.getDynamicAffineTransform((ReadGraph)graph, null, resource, DIA.HasDynamicTransform, true);
            ElementUtils.setTransform((IElement)e, (AffineTransform)tr);
        }
        catch (DatabaseException databaseException) {
            ElementUtils.setTransform((IElement)e, (AffineTransform)new AffineTransform());
        }
        procedure.execute(graph, (Object)e);
    }

    public static void readParameters(AsyncReadGraph graph, Resource resource, final IElement e) {
        graph.asyncRequest((Read)new ElementParameterRequest(resource), (Procedure)new ProcedureAdapter<Map<String, Object>>(){

            public void execute(Map<String, Object> result) {
                ElementUtils.setParameters((IElement)e, result);
            }
        });
    }

    public static ISynchronizationContext getContext(IDiagram diagram) {
        return (ISynchronizationContext)diagram.getHint(SynchronizationHints.CONTEXT);
    }

    public static ISynchronizationContext getContextChecked(IDiagram diagram) {
        ISynchronizationContext context = ElementFactoryUtil.getContext(diagram);
        if (context == null) {
            throw new IllegalStateException("diagram does not contain " + SynchronizationHints.CONTEXT + " hint");
        }
        return context;
    }

    public static ErrorHandler getErrorHandler(IDiagram diagram) {
        ISynchronizationContext context = ElementFactoryUtil.getContext(diagram);
        if (context == null) {
            return null;
        }
        return (ErrorHandler)context.get(SynchronizationHints.ERROR_HANDLER);
    }

    public static ErrorHandler getErrorHandlerChecked(IDiagram diagram) {
        ISynchronizationContext context = ElementFactoryUtil.getContextChecked(diagram);
        ErrorHandler errorHandler = (ErrorHandler)context.get(SynchronizationHints.ERROR_HANDLER);
        if (errorHandler == null) {
            throw new IllegalStateException("synchronization context " + context + " does not contain " + SynchronizationHints.ERROR_HANDLER + " hint");
        }
        return errorHandler;
    }

    public static <T> T getContextHint(IDiagram diagram, IHintContext.Key key) {
        ISynchronizationContext context = ElementFactoryUtil.getContext(diagram);
        if (context == null) {
            return null;
        }
        return context.get(key);
    }

    public static <T> T getContextHintChecked(IDiagram diagram, IHintContext.Key key) {
        return ElementFactoryUtil.getContextChecked(diagram).get(key);
    }

    public static void loadLayersForElement(AsyncReadGraph graph, IDiagram diagram, IElement e, Resource element, AsyncProcedure<IElement> callback) {
        GraphLayerManager layerManager = (GraphLayerManager)ElementFactoryUtil.getContextHint(diagram, GraphSynchronizationHints.GRAPH_LAYER_MANAGER);
        if (layerManager != null) {
            ElementFactoryUtil.loadLayersForElement(graph, layerManager, diagram, e, element, callback);
        } else {
            callback.execute(graph, (Object)e);
        }
    }

    public static void loadLayersForElement(AsyncReadGraph graph, GraphLayerManager layerManager, IDiagram diagram, IElement e, Resource element, AsyncProcedure<IElement> callback) {
        ILayers layers = (ILayers)diagram.getHint(DiagramHints.KEY_LAYERS);
        if (layers != null) {
            layerManager.loadLayersForElement(graph, layers, e, element, callback);
        } else {
            callback.execute(graph, (Object)e);
        }
    }
}

