package org.simantics.diagram.svg.export;

import java.awt.Font;
import java.awt.RenderingHints;
import java.awt.RenderingHints.Key;
import java.util.HashMap;
import java.util.Map;

import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGeneratorContext.GraphicContextDefaults;
import org.apache.batik.svggen.SVGGraphics2D;
import org.simantics.scenegraph.g2d.G2DPDFRenderingHints;
import org.simantics.scenegraph.g2d.G2DRenderingHints;
import org.w3c.dom.Document;

public class SVGGraphics2DWithPassthruSupport extends SVGGraphics2D {

	public SVGGraphics2DWithPassthruSupport(Document document) {
		this(SVGGeneratorContext.createDefault(document));
	}
	
	public SVGGraphics2DWithPassthruSupport(SVGGeneratorContext context) {
		super(updateDefaults(context), false);
		
		setRenderingHint(G2DRenderingHints.KEY_TEXT_RENDERING_MODE, G2DRenderingHints.TextRenderingMode.AS_TEXT);
		setRenderingHint(G2DRenderingHints.KEY_SVG_PASSTHRU, true);
		
		this.shapeConverter = new SVGShapeWithPassthruSupport(generatorCtx);
	}
	
	private static SVGGeneratorContext updateDefaults(SVGGeneratorContext context) {
		GraphicContextDefaults gcDefaults = new GraphicContextDefaults();
		
        Map<Key, Object> hintMap = new HashMap<Key, Object>();
		
		hintMap.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        hintMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
		hintMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
		hintMap.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
		hintMap.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
		
		gcDefaults.setRenderingHints(new RenderingHints(hintMap));
		gcDefaults.setFont(Font.decode(null));
		
		context.setGraphicContextDefaults(gcDefaults);
		return context;
	}
}